/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.async;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheActionDispatcher;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.InvalidateCacheAction;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.PutToCacheAction;

public class CacheWriteQueue<K, V> {
    private final CacheActionDispatcher dispatcher;
    private final PersistentCache cache;
    private final Map<K, V> map;
    final Multiset<K> queuedKeys = HashMultiset.create();
    final Set<K> waitsForInvalidation = new HashSet<K>();

    public CacheWriteQueue(CacheActionDispatcher dispatcher, PersistentCache cache, Map<K, V> map) {
        this.dispatcher = dispatcher;
        this.cache = cache;
        this.map = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvalidate(Iterable<K> keys) {
        CacheWriteQueue cacheWriteQueue = this;
        synchronized (cacheWriteQueue) {
            for (K key : keys) {
                this.queuedKeys.add(key);
                this.waitsForInvalidation.add(key);
            }
        }
        this.dispatcher.add(new InvalidateCacheAction(this, keys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPut(K key, V value) {
        CacheWriteQueue cacheWriteQueue = this;
        synchronized (cacheWriteQueue) {
            this.queuedKeys.add(key);
            this.waitsForInvalidation.remove(key);
        }
        this.dispatcher.add(new PutToCacheAction<K, V>(this, key, value));
    }

    public synchronized boolean waitsForInvalidation(K key) {
        return this.waitsForInvalidation.contains(key);
    }

    synchronized void remove(K key) {
        this.queuedKeys.remove(key);
        if (!this.queuedKeys.contains(key)) {
            this.waitsForInvalidation.remove(key);
        }
    }

    PersistentCache getCache() {
        return this.cache;
    }

    Map<K, V> getMap() {
        return this.map;
    }
}

