/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBConnectionHandler;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RDBDocumentStoreDB {
    DEFAULT("default"){}
    ,
    H2("H2"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 1, 4, this.description);
        }

        @Override
        public String getInitializationStatement() {
            return "create alias if not exists unix_timestamp as $$ long unix_timestamp() { return System.currentTimeMillis()/1000L; } $$;";
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select unix_timestamp()";
        }
    }
    ,
    DERBY("Apache Derby"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 10, 11, this.description);
        }

        @Override
        public boolean allowsCaseInSelect() {
            return false;
        }
    }
    ,
    POSTGRES("PostgreSQL"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 9, 3, this.description);
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select extract(epoch from now())::integer";
        }

        @Override
        public String getTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varchar(512) not null primary key, MODIFIED bigint, HASBINARY smallint, DELETEDONCE smallint, MODCOUNT bigint, CMODCOUNT bigint, DSIZE bigint, DATA varchar(16384), BDATA bytea)";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
            HashMap<String, String> result;
            block6: {
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                result = new HashMap<String, String>();
                try {
                    con = ch.getROConnection();
                    String cat = con.getCatalog();
                    stmt = con.prepareStatement("SELECT pg_encoding_to_char(encoding), datcollate FROM pg_database WHERE datname=?");
                    stmt.setString(1, cat);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        result.put("pg_encoding_to_char(encoding)", rs.getString(1));
                        result.put("datcollate", rs.getString(2));
                    }
                    stmt.close();
                    con.commit();
                    RDBJDBCTools.closeResultSet(rs);
                }
                catch (SQLException ex) {
                    LOG.debug("while getting diagnostics", (Throwable)ex);
                    break block6;
                }
                finally {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    ch.closeConnection(con);
                }
                RDBJDBCTools.closeStatement(stmt);
                ch.closeConnection(con);
            }
            return ((Object)result).toString();
        }
    }
    ,
    DB2("DB2"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 10, 1, this.description);
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select cast (days(current_timestamp - current_timezone) - days('1970-01-01') as integer) * 86400 + midnight_seconds(current_timestamp - current_timezone) from sysibm.sysdummy1";
        }

        @Override
        public String getTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varchar(512) not null, MODIFIED bigint, HASBINARY smallint, DELETEDONCE smallint, MODCOUNT bigint, CMODCOUNT bigint, DSIZE bigint, DATA varchar(16384), BDATA blob(" + 0x40000000 + "))";
        }

        @Override
        public List<String> getIndexCreationStatements(String tableName) {
            ArrayList<String> statements = new ArrayList<String>();
            String pkName = tableName + "_pk";
            statements.add("create unique index " + pkName + " on " + tableName + " ( ID ) cluster");
            statements.add("alter table " + tableName + " add constraint " + pkName + " primary key ( ID )");
            statements.addAll(super.getIndexCreationStatements(tableName));
            return statements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
            HashMap<String, String> result;
            block8: {
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                result = new HashMap<String, String>();
                try {
                    con = ch.getROConnection();
                    String conSchema = ch.getSchema(con);
                    StringBuilder sb = new StringBuilder();
                    sb.append("SELECT CODEPAGE, COLLATIONSCHEMA, COLLATIONNAME, TABSCHEMA FROM SYSCAT.COLUMNS WHERE COLNAME=? and COLNO=0 AND UPPER(TABNAME)=UPPER(?)");
                    if (conSchema != null) {
                        conSchema = conSchema.trim();
                        sb.append(" AND UPPER(TABSCHEMA)=UPPER(?)");
                    }
                    stmt = con.prepareStatement(sb.toString());
                    stmt.setString(1, "ID");
                    stmt.setString(2, tableName);
                    if (conSchema != null) {
                        stmt.setString(3, conSchema);
                    }
                    rs = stmt.executeQuery();
                    while (rs.next() && result.size() < 20) {
                        String schema = rs.getString("TABSCHEMA").trim();
                        result.put(schema + ".CODEPAGE", rs.getString("CODEPAGE").trim());
                        result.put(schema + ".COLLATIONSCHEMA", rs.getString("COLLATIONSCHEMA").trim());
                        result.put(schema + ".COLLATIONNAME", rs.getString("COLLATIONNAME").trim());
                    }
                    stmt.close();
                    con.commit();
                    RDBJDBCTools.closeResultSet(rs);
                }
                catch (SQLException ex) {
                    LOG.debug("while getting diagnostics", (Throwable)ex);
                    break block8;
                }
                finally {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    ch.closeConnection(con);
                }
                RDBJDBCTools.closeStatement(stmt);
                ch.closeConnection(con);
            }
            return ((Object)result).toString();
        }
    }
    ,
    ORACLE("Oracle"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 12, 1, 12, 1, this.description);
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select (trunc(sys_extract_utc(systimestamp)) - to_date('01/01/1970', 'MM/DD/YYYY')) * 24 * 60 * 60 + to_number(to_char(sys_extract_utc(systimestamp), 'SSSSS')) from dual";
        }

        @Override
        public String getInitializationStatement() {
            return "ALTER SESSION SET NLS_SORT='BINARY'";
        }

        @Override
        public String getTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varchar(512) not null primary key, MODIFIED number, HASBINARY number, DELETEDONCE number, MODCOUNT number, CMODCOUNT number, DSIZE number, DATA varchar(4000), BDATA blob)";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
            HashMap<String, String> result;
            block6: {
                Connection con = null;
                Statement stmt = null;
                ResultSet rs = null;
                result = new HashMap<String, String>();
                try {
                    con = ch.getROConnection();
                    stmt = con.createStatement();
                    rs = stmt.executeQuery("SELECT PARAMETER, VALUE from NLS_DATABASE_PARAMETERS WHERE PARAMETER IN ('NLS_COMP', 'NLS_CHARACTERSET')");
                    while (rs.next()) {
                        result.put(rs.getString(1), rs.getString(2));
                    }
                    stmt.close();
                    con.commit();
                    RDBJDBCTools.closeResultSet(rs);
                }
                catch (SQLException ex) {
                    LOG.debug("while getting diagnostics", (Throwable)ex);
                    break block6;
                }
                finally {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    ch.closeConnection(con);
                }
                RDBJDBCTools.closeStatement(stmt);
                ch.closeConnection(con);
            }
            return ((Object)result).toString();
        }
    }
    ,
    MYSQL("MySQL"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 5, 5, this.description);
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select unix_timestamp()";
        }

        @Override
        public String getTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varbinary(512) not null primary key, MODIFIED bigint, HASBINARY smallint, DELETEDONCE smallint, MODCOUNT bigint, CMODCOUNT bigint, DSIZE bigint, DATA varchar(16000), BDATA longblob)";
        }

        @Override
        public FETCHFIRSTSYNTAX getFetchFirstSyntax() {
            return FETCHFIRSTSYNTAX.LIMIT;
        }

        @Override
        public RDBJDBCTools.PreparedStatementComponent getConcatQuery(final String appendData, int dataOctetLimit) {
            return new RDBJDBCTools.PreparedStatementComponent(){

                @Override
                public String getStatementComponent() {
                    return "CONCAT(DATA, ?)";
                }

                @Override
                public int setParameters(PreparedStatement stmt, int startIndex) throws SQLException {
                    stmt.setString(startIndex++, appendData);
                    return startIndex;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
            HashMap<String, String> result;
            block7: {
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                result = new HashMap<String, String>();
                try {
                    con = ch.getROConnection();
                    stmt = con.prepareStatement("SHOW TABLE STATUS LIKE ?");
                    stmt.setString(1, tableName);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        result.put("collation", rs.getString("Collation"));
                    }
                    rs.close();
                    stmt.close();
                    stmt = con.prepareStatement("SHOW VARIABLES WHERE variable_name LIKE 'character\\_set\\_%' OR variable_name LIKE 'collation%' OR variable_name = 'max_allowed_packet'");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        result.put(rs.getString(1), rs.getString(2));
                    }
                    stmt.close();
                    con.commit();
                    RDBJDBCTools.closeResultSet(rs);
                }
                catch (SQLException ex) {
                    LOG.debug("while getting diagnostics", (Throwable)ex);
                    break block7;
                }
                finally {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    ch.closeConnection(con);
                }
                RDBJDBCTools.closeStatement(stmt);
                ch.closeConnection(con);
            }
            return ((Object)result).toString();
        }
    }
    ,
    MSSQL("Microsoft SQL Server"){

        @Override
        public String checkVersion(DatabaseMetaData md) throws SQLException {
            return RDBJDBCTools.versionCheck(md, 11, 0, this.description);
        }

        @Override
        public String getTableCreationStatement(String tableName) {
            return "create table " + tableName + " (ID varbinary(512) not null primary key, MODIFIED bigint, HASBINARY smallint, DELETEDONCE smallint, MODCOUNT bigint, CMODCOUNT bigint, DSIZE bigint, DATA nvarchar(4000), BDATA varbinary(max))";
        }

        @Override
        public FETCHFIRSTSYNTAX getFetchFirstSyntax() {
            return FETCHFIRSTSYNTAX.TOP;
        }

        @Override
        public RDBJDBCTools.PreparedStatementComponent getConcatQuery(final String appendData, final int dataOctetLimit) {
            return new RDBJDBCTools.PreparedStatementComponent(){

                @Override
                public String getStatementComponent() {
                    return "CASE WHEN LEN(DATA) < ? THEN (DATA + CAST(? AS nvarchar(" + dataOctetLimit + "))) ELSE (DATA + CAST(DATA AS nvarchar(max))) END";
                }

                @Override
                public int setParameters(PreparedStatement stmt, int startIndex) throws SQLException {
                    stmt.setInt(startIndex++, dataOctetLimit - appendData.length());
                    stmt.setString(startIndex++, appendData);
                    return startIndex;
                }
            };
        }

        @Override
        public String getCurrentTimeStampInSecondsSyntax() {
            return "select datediff(second, dateadd(second, datediff(second, getutcdate(), getdate()), '1970-01-01'), getdate())";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
            HashMap<String, String> result;
            block6: {
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                result = new HashMap<String, String>();
                try {
                    con = ch.getROConnection();
                    String cat = con.getCatalog();
                    stmt = con.prepareStatement("SELECT collation_name FROM sys.databases WHERE name=?");
                    stmt.setString(1, cat);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        result.put("collation_name", rs.getString(1));
                    }
                    stmt.close();
                    con.commit();
                    RDBJDBCTools.closeResultSet(rs);
                }
                catch (SQLException ex) {
                    LOG.debug("while getting diagnostics", (Throwable)ex);
                    break block6;
                }
                finally {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    ch.closeConnection(con);
                }
                RDBJDBCTools.closeStatement(stmt);
                ch.closeConnection(con);
            }
            return ((Object)result).toString();
        }
    };

    private static final Logger LOG;
    private static final String CREATEINDEX;
    protected String description;

    public String checkVersion(DatabaseMetaData md) throws SQLException {
        return "Unknown database type: " + md.getDatabaseProductName();
    }

    public boolean allowsCaseInSelect() {
        return true;
    }

    public FETCHFIRSTSYNTAX getFetchFirstSyntax() {
        return FETCHFIRSTSYNTAX.FETCHFIRST;
    }

    public String getCurrentTimeStampInSecondsSyntax() {
        return "";
    }

    public RDBJDBCTools.PreparedStatementComponent getConcatQuery(final String appendData, final int dataOctetLimit) {
        return new RDBJDBCTools.PreparedStatementComponent(){

            @Override
            public String getStatementComponent() {
                return "DATA || CAST(? AS varchar(" + dataOctetLimit + "))";
            }

            @Override
            public int setParameters(PreparedStatement stmt, int startIndex) throws SQLException {
                stmt.setString(startIndex++, appendData);
                return startIndex;
            }
        };
    }

    @Nonnull
    public String getInitializationStatement() {
        return "";
    }

    public String getTableCreationStatement(String tableName) {
        return "create table " + tableName + " (ID varchar(512) not null primary key, MODIFIED bigint, HASBINARY smallint, DELETEDONCE smallint, MODCOUNT bigint, CMODCOUNT bigint, DSIZE bigint, DATA varchar(16384), BDATA blob(" + 0x40000000 + "))";
    }

    public List<String> getIndexCreationStatements(String tableName) {
        if (CREATEINDEX.equals("modified-id")) {
            return Collections.singletonList("create index " + tableName + "_MI on " + tableName + " (MODIFIED, ID)");
        }
        if (CREATEINDEX.equals("id-modified")) {
            return Collections.singletonList("create index " + tableName + "_MI on " + tableName + " (ID, MODIFIED)");
        }
        if (CREATEINDEX.equals("modified")) {
            return Collections.singletonList("create index " + tableName + "_MI on " + tableName + " (MODIFIED)");
        }
        return Collections.emptyList();
    }

    public String getAdditionalDiagnostics(RDBConnectionHandler ch, String tableName) {
        return "";
    }

    private RDBDocumentStoreDB(String description) {
        this.description = description;
    }

    public String toString() {
        return this.description;
    }

    @Nonnull
    public static RDBDocumentStoreDB getValue(String desc) {
        for (RDBDocumentStoreDB db : RDBDocumentStoreDB.values()) {
            if (db.description.equals(desc)) {
                return db;
            }
            if (db != DB2 || !desc.startsWith("DB2/")) continue;
            return db;
        }
        LOG.error("DB type " + desc + " unknown, trying default settings");
        RDBDocumentStoreDB.DEFAULT.description = desc + " - using default settings";
        return DEFAULT;
    }

    static {
        LOG = LoggerFactory.getLogger(RDBDocumentStoreDB.class);
        CREATEINDEX = System.getProperty("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.CREATEINDEX", "");
    }

    public static enum FETCHFIRSTSYNTAX {
        FETCHFIRST,
        LIMIT,
        TOP;

    }
}

