/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final int REVISION_LENGTH = new Revision(System.currentTimeMillis(), 0, 0).toString().length();
    static final int PATH_SHORT = Integer.getInteger("oak.pathShort", 165);
    static final int PATH_LONG = Integer.getInteger("oak.pathLong", 350);
    public static final int NODE_NAME_LIMIT = Integer.getInteger("oak.nodeNameLimit", 150);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Predicate<String> PROPERTY_OR_DELETED = new Predicate<String>(){

        public boolean apply(@Nullable String input) {
            return Utils.isPropertyName(input) || NodeDocument.isDeletedEntry(input);
        }
    };

    public static String unshareString(String x) {
        return new String(x);
    }

    public static int pathDepth(String path) {
        if (path.equals("/")) {
            return 0;
        }
        int depth = 0;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '/') continue;
            ++depth;
        }
        return depth;
    }

    public static int estimateMemoryUsage(Map<?, Object> map) {
        if (map == null) {
            return 0;
        }
        int size = 0;
        for (Map.Entry<?, Object> e : map.entrySet()) {
            size = e.getKey() instanceof Revision ? (size += 32) : (size += StringUtils.estimateMemoryUsage(e.getKey().toString()));
            Object o = e.getValue();
            if (o instanceof String) {
                size += StringUtils.estimateMemoryUsage((String)o);
                continue;
            }
            if (o instanceof Long) {
                size += 16;
                continue;
            }
            if (o instanceof Boolean) {
                size += 8;
                continue;
            }
            if (o instanceof Integer) {
                size += 8;
                continue;
            }
            if (o instanceof Map) {
                size += 8 + Utils.estimateMemoryUsage((Map)o);
                continue;
            }
            if (o == null) continue;
            throw new IllegalArgumentException("Can't estimate memory usage of " + o);
        }
        size += 112;
        return size += map.size() * 64;
    }

    public static String escapePropertyName(String propertyName) {
        int len = propertyName.length();
        if (len == 0) {
            return "_";
        }
        StringBuilder buff = null;
        char c = propertyName.charAt(0);
        int i = 0;
        if (c == '_' || c == '$') {
            buff = new StringBuilder(len + 1);
            buff.append('_').append(c);
            ++i;
        }
        while (i < len) {
            char rep;
            c = propertyName.charAt(i);
            switch (c) {
                case '.': {
                    rep = 'd';
                    break;
                }
                case '\\': {
                    rep = '\\';
                    break;
                }
                default: {
                    rep = '\u0000';
                }
            }
            if (rep != '\u0000') {
                if (buff == null) {
                    buff = new StringBuilder(propertyName.substring(0, i));
                }
                buff.append('\\').append(rep);
            } else if (buff != null) {
                buff.append(c);
            }
            ++i;
        }
        return buff == null ? propertyName : buff.toString();
    }

    public static String unescapePropertyName(String key) {
        int len = key.length();
        if (key.startsWith("_") && (key.startsWith("__") || key.startsWith("_$") || len == 1)) {
            key = key.substring(1);
            --len;
        }
        StringBuilder buff = null;
        for (int i = 0; i < len; ++i) {
            int c = key.charAt(i);
            if (c == 92) {
                if (buff == null) {
                    buff = new StringBuilder(key.substring(0, i));
                }
                if ((c = key.charAt(++i)) != 92 && c == 100) {
                    c = 46;
                }
                buff.append((char)c);
                continue;
            }
            if (buff == null) continue;
            buff.append((char)c);
        }
        return buff == null ? key : buff.toString();
    }

    public static boolean isPropertyName(String key) {
        return !key.startsWith("_") || key.startsWith("__") || key.startsWith("_$");
    }

    public static String getIdFromPath(String path) {
        if (Utils.isLongPath(path)) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            int depth = Utils.pathDepth(path);
            String parent = PathUtils.getParentPath(path);
            byte[] hash = digest.digest(parent.getBytes(UTF_8));
            String name = PathUtils.getName(path);
            return depth + ":h" + Hex.encodeHexString((byte[])hash) + "/" + name;
        }
        int depth = Utils.pathDepth(path);
        return depth + ":" + path;
    }

    @CheckForNull
    public static String getParentId(String id) {
        if (Utils.isIdFromLongPath(id)) {
            return null;
        }
        String path = Utils.getPathFromId(id);
        if (!PathUtils.isValid(path)) {
            return null;
        }
        if (PathUtils.denotesRoot(path)) {
            return null;
        }
        String parentPath = PathUtils.getParentPath(path);
        return Utils.getIdFromPath(parentPath);
    }

    public static boolean isLongPath(String path) {
        if (path.length() < PATH_SHORT) {
            return false;
        }
        byte[] parent = PathUtils.getParentPath(path).getBytes(UTF_8);
        if (parent.length < PATH_LONG) {
            return false;
        }
        String name = PathUtils.getName(path);
        if (name.getBytes(UTF_8).length > NODE_NAME_LIMIT) {
            throw new IllegalArgumentException("Node name is too long: " + path);
        }
        return true;
    }

    public static boolean isIdFromLongPath(String id) {
        int index = id.indexOf(58);
        return id.charAt(index + 1) == 'h';
    }

    public static String getPathFromId(String id) {
        if (Utils.isIdFromLongPath(id)) {
            throw new IllegalArgumentException("Id is hashed: " + id);
        }
        int index = id.indexOf(58);
        return id.substring(index + 1);
    }

    public static int getDepthFromId(String id) {
        int index = id.indexOf(58);
        assert (index > 0) : "Invalid id " + id;
        return Integer.parseInt(id.substring(0, index));
    }

    public static String getPreviousPathFor(String path, Revision r, int height) {
        if (!PathUtils.isAbsolute(path)) {
            throw new IllegalArgumentException("path must be absolute: " + path);
        }
        StringBuilder sb = new StringBuilder(path.length() + REVISION_LENGTH + 3);
        sb.append("p").append(path);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        r.toStringBuilder(sb).append("/").append(height);
        return sb.toString();
    }

    public static String getPreviousIdFor(String path, Revision r, int height) {
        return Utils.getIdFromPath(Utils.getPreviousPathFor(path, r, height));
    }

    public static boolean isPreviousDocId(String id) {
        int indexOfColon = id.indexOf(58);
        if (indexOfColon > 0 && indexOfColon < id.length() - 1) {
            return id.charAt(indexOfColon + 1) == 'p';
        }
        return false;
    }

    public static boolean isLeafPreviousDocId(String id) {
        return Utils.isPreviousDocId(id) && id.endsWith("/0");
    }

    public static <K> void deepCopyMap(Map<K, Object> source, Map<K, Object> target) {
        for (Map.Entry<K, Object> e : source.entrySet()) {
            TreeMap value = e.getValue();
            Comparator comparator = null;
            if (value instanceof SortedMap) {
                SortedMap map = value;
                comparator = map.comparator();
            }
            if (value instanceof Map) {
                Map old = value;
                TreeMap c = new TreeMap(comparator);
                Utils.deepCopyMap(old, c);
                value = c;
            }
            target.put(e.getKey(), value);
        }
    }

    public static String getKeyLowerLimit(String path) {
        String from = PathUtils.concat(path, "a");
        from = Utils.getIdFromPath(from);
        from = from.substring(0, from.length() - 1);
        return from;
    }

    public static String getKeyUpperLimit(String path) {
        String to = PathUtils.concat(path, "z");
        to = Utils.getIdFromPath(to);
        to = to.substring(0, to.length() - 2) + "0";
        return to;
    }

    @CheckForNull
    public static String getParentIdFromLowerLimit(String fromKey) {
        if (fromKey.endsWith("/")) {
            fromKey = fromKey + "a";
        }
        return Utils.getParentId(fromKey);
    }

    public static boolean isCommitted(@Nullable String tag) {
        return tag != null && (tag.equals("c") || tag.startsWith("c-"));
    }

    @Nonnull
    public static Revision resolveCommitRevision(@Nonnull Revision rev, @Nonnull String tag) {
        return ((String)Preconditions.checkNotNull((Object)tag)).startsWith("c-") ? Revision.fromString(tag.substring(2)) : rev;
    }

    public static void closeIfCloseable(Object obj) {
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (IOException e) {
                LOG.warn("Error occurred while closing {}", obj, (Object)e);
            }
        }
    }

    public static String timestampToString(long timestamp) {
        return (new Timestamp(timestamp) + "00").substring(0, 23);
    }

    @CheckForNull
    public static Revision max(@Nullable Revision a, @Nullable Revision b) {
        return Utils.max(a, b, StableRevisionComparator.INSTANCE);
    }

    @CheckForNull
    public static Revision max(@Nullable Revision a, @Nullable Revision b, @Nonnull Comparator<Revision> c) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return c.compare(a, b) >= 0 ? a : b;
    }

    @CheckForNull
    public static Revision min(@Nullable Revision a, @Nullable Revision b) {
        return Utils.min(a, b, StableRevisionComparator.INSTANCE);
    }

    @CheckForNull
    public static Revision min(@Nullable Revision a, @Nullable Revision b, @Nonnull Comparator<Revision> c) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return c.compare(a, b) <= 0 ? a : b;
    }

    public static Iterable<NodeDocument> getAllDocuments(DocumentStore store) {
        return Utils.internalGetSelectedDocuments(store, null, 0L);
    }

    @Nonnull
    public static NodeDocument getRootDocument(@Nonnull DocumentStore store) {
        String rootId = Utils.getIdFromPath("/");
        NodeDocument root = store.find(Collection.NODES, rootId);
        if (root == null) {
            throw new IllegalStateException("missing root document");
        }
        return root;
    }

    public static Iterable<NodeDocument> getSelectedDocuments(DocumentStore store, String indexedProperty, long startValue) {
        return Utils.internalGetSelectedDocuments(store, indexedProperty, startValue);
    }

    private static Iterable<NodeDocument> internalGetSelectedDocuments(final DocumentStore store, final String indexedProperty, final long startValue) {
        return new Iterable<NodeDocument>(){

            @Override
            public Iterator<NodeDocument> iterator() {
                return new AbstractIterator<NodeDocument>(){
                    private static final int BATCH_SIZE = 100;
                    private String startId = "0000000";
                    private Iterator<NodeDocument> batch = this.nextBatch();

                    protected NodeDocument computeNext() {
                        NodeDocument doc;
                        if (!this.batch.hasNext()) {
                            this.batch = this.nextBatch();
                        }
                        if (this.batch.hasNext()) {
                            doc = this.batch.next();
                            this.startId = doc.getId();
                        } else {
                            doc = (NodeDocument)this.endOfData();
                        }
                        return doc;
                    }

                    private Iterator<NodeDocument> nextBatch() {
                        List<NodeDocument> result = indexedProperty == null ? store.query(Collection.NODES, this.startId, ";", 100) : store.query(Collection.NODES, this.startId, ";", indexedProperty, startValue, 100);
                        return result.iterator();
                    }
                };
            }
        };
    }

    public static boolean isHiddenPath(@Nonnull String path) {
        return path.contains("/:");
    }

    public static Iterable<StringValue> asStringValueIterable(@Nonnull Iterable<String> values) {
        return Iterables.transform(values, (Function)new Function<String, StringValue>(){

            public StringValue apply(String input) {
                return new StringValue(input);
            }
        });
    }

    public static Iterable<String> pathToId(@Nonnull Iterable<String> paths) {
        return Iterables.transform(paths, (Function)new Function<String, String>(){

            public String apply(String input) {
                return Utils.getIdFromPath(input);
            }
        });
    }

    public static long getMaxExternalTimestamp(Iterable<Revision> revisions, int localClusterId) {
        long maxTime = Long.MIN_VALUE;
        for (Revision r : revisions) {
            if (r.getClusterId() == localClusterId) continue;
            maxTime = Math.max(maxTime, r.getTimestamp());
        }
        return maxTime;
    }

    public static Long asLong(@Nullable Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Long) {
            return (Long)n;
        }
        return n.longValue();
    }

    public static long getMinTimestampForDiff(@Nonnull RevisionVector fromRev, @Nonnull RevisionVector toRev, @Nonnull RevisionVector minRevisions) {
        fromRev = fromRev.pmax(minRevisions);
        toRev = toRev.pmax(minRevisions);
        RevisionVector from = fromRev.difference(toRev);
        RevisionVector to = toRev.difference(fromRev);
        long min = Long.MAX_VALUE;
        for (Revision r : from) {
            min = Math.min(r.getTimestamp(), min);
        }
        for (Revision r : to) {
            min = Math.min(r.getTimestamp(), min);
        }
        return min;
    }
}

