/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.plugins.commit.AnnotatingConflictHandler;
import org.apache.jackrabbit.oak.plugins.commit.ConflictHook;
import org.apache.jackrabbit.oak.plugins.commit.ConflictValidatorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexMBeanRegistration;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.stats.TimeSeriesRecorder;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncIndexUpdate
implements Runnable,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(AsyncIndexUpdate.class);
    static final String ASYNC = ":async";
    private static final long DEFAULT_LIFETIME = TimeUnit.DAYS.toMillis(1000L);
    private static final CommitFailedException CONCURRENT_UPDATE = new CommitFailedException("Async", 1, "Concurrent update detected");
    private static final CommitFailedException INTERRUPTED = new CommitFailedException("Async", 1, "Indexing stopped forcefully");
    private static final long DEFAULT_ASYNC_TIMEOUT;
    private final String name;
    private final NodeStore store;
    private final IndexEditorProvider provider;
    private final String lastIndexedTo;
    private final long lifetime = DEFAULT_LIFETIME;
    private final AsyncIndexStats indexStats = new AsyncIndexStats();
    private final boolean switchOnSync;
    private final Set<String> reindexedDefinitions = new HashSet<String>();
    private final IndexUpdate.MissingIndexProviderStrategy missingStrategy = new DefaultMissingIndexProviderStrategy();
    private final IndexTaskSpliter taskSplitter = new IndexTaskSpliter();
    private final Semaphore runPermit = new Semaphore(1);
    private final AtomicBoolean forcedStopFlag = new AtomicBoolean();
    private IndexMBeanRegistration mbeanRegistration;
    private long leaseTimeOut;
    private static long ERROR_WARN_INTERVAL;
    private int softTimeOutSecs = Integer.getInteger("oak.async.softTimeOutSecs", 120);
    private boolean closed;

    public AsyncIndexUpdate(@Nonnull String name, @Nonnull NodeStore store, @Nonnull IndexEditorProvider provider, boolean switchOnSync) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.lastIndexedTo = name + "-LastIndexedTo";
        this.store = (NodeStore)Preconditions.checkNotNull((Object)store);
        this.provider = (IndexEditorProvider)Preconditions.checkNotNull((Object)provider);
        this.switchOnSync = switchOnSync;
        this.leaseTimeOut = DEFAULT_ASYNC_TIMEOUT;
    }

    public AsyncIndexUpdate(@Nonnull String name, @Nonnull NodeStore store, @Nonnull IndexEditorProvider provider) {
        this(name, store, provider, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        boolean permitAcquired = false;
        try {
            if (this.runPermit.tryAcquire()) {
                permitAcquired = true;
                this.runWhenPermitted();
            } else {
                log.warn("[{}] Could not acquire run permit. Stop flag set to [{}] Skipping the run", (Object)this.name, (Object)this.forcedStopFlag);
            }
        }
        finally {
            if (permitAcquired) {
                this.runPermit.release();
            }
        }
    }

    @Override
    public void close() {
        block7: {
            if (this.closed) {
                return;
            }
            int hardTimeOut = 5 * this.softTimeOutSecs;
            if (!this.runPermit.tryAcquire()) {
                log.debug("[{}] [WAITING] Indexing in progress. Would wait for {} secs for it to finish", (Object)this.name, (Object)this.softTimeOutSecs);
                try {
                    if (!this.runPermit.tryAcquire(this.softTimeOutSecs, TimeUnit.SECONDS)) {
                        log.debug("[{}] [SOFT LIMIT HIT] Indexing found to be in progress for more than [{}]s. Would signal it to now force stop", (Object)this.name, (Object)this.softTimeOutSecs);
                        this.forcedStopFlag.set(true);
                        if (!this.runPermit.tryAcquire(hardTimeOut, TimeUnit.SECONDS)) {
                            log.warn("[{}] Indexing still not found to be complete. Giving up after [{}]s", (Object)this.name, (Object)hardTimeOut);
                        }
                        break block7;
                    }
                    log.info("[{}] [CLOSED OK] Async indexing run completed. Closing it now", (Object)this.name);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                log.info("[{}] Closed", (Object)this.name);
            }
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWhenPermitted() {
        NodeState before;
        if (this.indexStats.isPaused()) {
            return;
        }
        log.debug("[{}] Running background index task", (Object)this.name);
        NodeState root = this.store.getRoot();
        NodeState async = root.getChildNode(ASYNC);
        long leaseEndTime = async.getLong(AsyncIndexUpdate.leasify(this.name));
        long currentTime = System.currentTimeMillis();
        if (leaseEndTime > currentTime) {
            long leaseExpMsg = (leaseEndTime - currentTime) / 1000L;
            String err = "Another copy of the index update is already running; skipping this update. Time left for lease to expire " + leaseExpMsg + "s";
            this.indexStats.failed(new Exception(err, CONCURRENT_UPDATE));
            return;
        }
        AsyncIndexUpdate.preAsyncRunStatsStats(this.indexStats);
        String beforeCheckpoint = async.getString(this.name);
        if (beforeCheckpoint != null) {
            NodeState state = this.store.retrieve(beforeCheckpoint);
            if (state == null) {
                log.warn("[{}] Failed to retrieve previously indexed checkpoint {}; re-running the initial index update", (Object)this.name, (Object)beforeCheckpoint);
                beforeCheckpoint = null;
                before = EmptyNodeState.MISSING_NODE;
            } else {
                if (AsyncIndexUpdate.noVisibleChanges(state, root)) {
                    log.debug("[{}] No changes since last checkpoint; skipping the index update", (Object)this.name);
                    AsyncIndexUpdate.postAsyncRunStatsStatus(this.indexStats);
                    return;
                }
                before = state;
            }
        } else {
            log.info("[{}] Initial index update", (Object)this.name);
            before = EmptyNodeState.MISSING_NODE;
        }
        String afterTime = AsyncIndexUpdate.now();
        String oldThreadName = Thread.currentThread().getName();
        boolean threadNameChanged = false;
        String afterCheckpoint = this.store.checkpoint(this.lifetime, (Map<String, String>)ImmutableMap.of((Object)"creator", (Object)AsyncIndexUpdate.class.getSimpleName(), (Object)"thread", (Object)oldThreadName, (Object)"name", (Object)this.name));
        NodeState after = this.store.retrieve(afterCheckpoint);
        if (after == null) {
            log.debug("[{}] Unable to retrieve newly created checkpoint {}, skipping the index update", (Object)this.name, (Object)afterCheckpoint);
            return;
        }
        String checkpointToRelease = afterCheckpoint;
        boolean updatePostRunStatus = false;
        try {
            String newThreadName = "aysnc-index-update-" + this.name;
            log.trace("Switching thread name to {}", (Object)newThreadName);
            threadNameChanged = true;
            Thread.currentThread().setName(newThreadName);
            updatePostRunStatus = this.updateIndex(before, beforeCheckpoint, after, afterCheckpoint, afterTime);
            if (this.indexStats.isFailing()) {
                this.indexStats.fixed();
            }
            checkpointToRelease = beforeCheckpoint;
            this.indexStats.setReferenceCheckpoint(afterCheckpoint);
            this.indexStats.setProcessedCheckpoint("");
            this.indexStats.releaseTempCheckpoint(afterCheckpoint);
        }
        catch (Exception e) {
            this.indexStats.failed(e);
        }
        finally {
            if (threadNameChanged) {
                log.trace("Switching thread name back to {}", (Object)oldThreadName);
                Thread.currentThread().setName(oldThreadName);
            }
            if (checkpointToRelease != null && !checkpointToRelease.equals(this.taskSplitter.getLastReferencedCp()) && !this.store.release(checkpointToRelease)) {
                log.debug("[{}] Unable to release checkpoint {}", (Object)this.name, (Object)checkpointToRelease);
            }
            if (updatePostRunStatus) {
                AsyncIndexUpdate.postAsyncRunStatsStatus(this.indexStats);
            }
        }
    }

    protected AsyncUpdateCallback newAsyncUpdateCallback(NodeStore store, String name, long leaseTimeOut, String beforeCheckpoint, String afterCheckpoint, AsyncIndexStats indexStats, AtomicBoolean stopFlag) {
        return new AsyncUpdateCallback(store, name, leaseTimeOut, beforeCheckpoint, afterCheckpoint, indexStats, stopFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateIndex(NodeState before, String beforeCheckpoint, NodeState after, String afterCheckpoint, String afterTime) throws CommitFailedException {
        Stopwatch watch = Stopwatch.createStarted();
        boolean updatePostRunStatus = true;
        boolean progressLogged = false;
        AsyncUpdateCallback callback = this.newAsyncUpdateCallback(this.store, this.name, this.leaseTimeOut, beforeCheckpoint, afterCheckpoint, this.indexStats, this.forcedStopFlag);
        callback.prepare();
        this.taskSplitter.maybeSplit(beforeCheckpoint, callback.lease);
        try {
            NodeBuilder builder = this.store.getRoot().builder();
            IndexUpdate indexUpdate = new IndexUpdate(this.provider, this.name, after, builder, callback).withMissingProviderStrategy(this.missingStrategy);
            CommitFailedException exception = EditorDiff.process(VisibleEditor.wrap(indexUpdate), before, after);
            if (exception != null) {
                throw exception;
            }
            builder.child(ASYNC).setProperty(this.name, afterCheckpoint);
            builder.child(ASYNC).setProperty(PropertyStates.createProperty(this.lastIndexedTo, (Object)afterTime, Type.DATE));
            if (callback.isDirty() || before == EmptyNodeState.MISSING_NODE) {
                if (this.switchOnSync) {
                    this.reindexedDefinitions.addAll(indexUpdate.getReindexedDefinitions());
                    updatePostRunStatus = false;
                } else {
                    updatePostRunStatus = true;
                }
            } else {
                if (this.switchOnSync) {
                    log.debug("[{}] No changes detected after diff; will try to switch to synchronous updates on {}", (Object)this.name, this.reindexedDefinitions);
                    for (String path : this.reindexedDefinitions) {
                        NodeBuilder c = builder;
                        for (String p : PathUtils.elements(path)) {
                            c = c.getChildNode(p);
                        }
                        if (!c.exists() || c.getBoolean("reindex")) continue;
                        c.removeProperty("async");
                    }
                    this.reindexedDefinitions.clear();
                }
                updatePostRunStatus = true;
            }
            AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, builder, beforeCheckpoint, callback.lease, this.name);
            if (indexUpdate.isReindexingPerformed()) {
                log.info("[{}] Reindexing completed for indexes: {} in {}", new Object[]{this.name, indexUpdate.getReindexStats(), watch});
                progressLogged = true;
            }
        }
        finally {
            callback.close();
        }
        if (!progressLogged) {
            String msg = "[{}] AsyncIndex update run completed in {}. Indexed {} nodes";
            if (watch.elapsed(TimeUnit.MINUTES) >= 5L) {
                log.info(msg, new Object[]{this.name, watch, this.indexStats.getUpdates()});
            } else {
                log.debug(msg, new Object[]{this.name, watch, this.indexStats.getUpdates()});
            }
        }
        return updatePostRunStatus;
    }

    private static String leasify(String name) {
        return name + "-lease";
    }

    private static String getTempCpName(String name) {
        return name + "-temp";
    }

    private static void mergeWithConcurrencyCheck(NodeStore store, NodeBuilder builder, final String checkpoint, final long lease, final String name) throws CommitFailedException {
        CommitHook concurrentUpdateCheck = new CommitHook(){

            @Override
            @Nonnull
            public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
                NodeState async = before.getChildNode(AsyncIndexUpdate.ASYNC);
                if ((checkpoint == null || Objects.equal((Object)checkpoint, (Object)async.getString(name))) && lease == async.getLong(AsyncIndexUpdate.leasify(name))) {
                    return after;
                }
                throw CONCURRENT_UPDATE;
            }
        };
        CompositeHook hooks = new CompositeHook(new ConflictHook(new AnnotatingConflictHandler()), new EditorHook(new ConflictValidatorProvider()), concurrentUpdateCheck);
        try {
            store.merge(builder, hooks, CommitInfo.EMPTY);
        }
        catch (CommitFailedException ex) {
            if (ex.isOfType("State") && ex.getCode() == 1) {
                throw CONCURRENT_UPDATE;
            }
            throw ex;
        }
    }

    protected AsyncIndexUpdate setLeaseTimeOut(long leaseTimeOut) {
        this.leaseTimeOut = leaseTimeOut;
        return this;
    }

    protected AsyncIndexUpdate setCloseTimeOut(int timeOutInSec) {
        this.softTimeOutSecs = timeOutInSec;
        return this;
    }

    public boolean isClosed() {
        return this.closed || this.forcedStopFlag.get();
    }

    boolean isClosing() {
        return this.runPermit.hasQueuedThreads();
    }

    private static void preAsyncRunStatsStats(AsyncIndexStats stats) {
        stats.start(AsyncIndexUpdate.now());
    }

    private static void postAsyncRunStatsStatus(AsyncIndexStats stats) {
        stats.done(AsyncIndexUpdate.now());
    }

    private static String now() {
        return ISO8601.format(Calendar.getInstance());
    }

    public AsyncIndexStats getIndexStats() {
        return this.indexStats;
    }

    public boolean isFinished() {
        return this.indexStats.getStatus() == "done";
    }

    private static boolean noVisibleChanges(NodeState before, NodeState after) {
        return after.compareAgainstBaseState(before, new NodeStateDiff(){

            @Override
            public boolean propertyAdded(PropertyState after) {
                return AsyncIndexUpdate.isHidden(after.getName());
            }

            @Override
            public boolean propertyChanged(PropertyState before, PropertyState after) {
                return AsyncIndexUpdate.isHidden(after.getName());
            }

            @Override
            public boolean propertyDeleted(PropertyState before) {
                return AsyncIndexUpdate.isHidden(before.getName());
            }

            @Override
            public boolean childNodeAdded(String name, NodeState after) {
                return AsyncIndexUpdate.isHidden(name);
            }

            @Override
            public boolean childNodeChanged(String name, NodeState before, NodeState after) {
                return AsyncIndexUpdate.isHidden(name) || after.compareAgainstBaseState(before, this);
            }

            @Override
            public boolean childNodeDeleted(String name, NodeState before) {
                return AsyncIndexUpdate.isHidden(name);
            }
        });
    }

    private static boolean isHidden(String name) {
        return name.charAt(0) == ':';
    }

    public boolean isFailing() {
        return this.indexStats.isFailing();
    }

    private static Iterable<String> getStrings(NodeBuilder b, String p) {
        PropertyState ps = b.getProperty(p);
        if (ps != null) {
            return ps.getValue(Type.STRINGS);
        }
        return Sets.newHashSet();
    }

    IndexTaskSpliter getTaskSplitter() {
        return this.taskSplitter;
    }

    public void setIndexMBeanRegistration(IndexMBeanRegistration mbeanRegistration) {
        this.mbeanRegistration = mbeanRegistration;
    }

    protected String getName() {
        return this.name;
    }

    static {
        int value = 15;
        try {
            value = Integer.parseInt(System.getProperty("oak.async.lease.timeout", "15"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        DEFAULT_ASYNC_TIMEOUT = TimeUnit.MINUTES.toMillis(value);
        ERROR_WARN_INTERVAL = TimeUnit.MINUTES.toMillis(Integer.getInteger("oak.async.warn.interval", 30).intValue());
    }

    class IndexTaskSpliter {
        private Set<String> paths = null;
        private String newIndexTaskName = null;
        private String lastReferencedCp;
        private Set<String> registeredTasks = Sets.newHashSet();

        IndexTaskSpliter() {
        }

        void registerSplit(Set<String> paths, String newIndexTaskName) {
            log.info("[{}] Registered split of following index definitions {} to new async task {}.", new Object[]{AsyncIndexUpdate.this.name, paths, newIndexTaskName});
            this.paths = Sets.newHashSet(paths);
            this.newIndexTaskName = newIndexTaskName;
        }

        void maybeSplit(@CheckForNull String refCheckpoint, long lease) throws CommitFailedException {
            if (this.paths == null) {
                return;
            }
            this.split(refCheckpoint, lease);
        }

        private void split(@CheckForNull String refCheckpoint, long lease) throws CommitFailedException {
            NodeBuilder builder = AsyncIndexUpdate.this.store.getRoot().builder();
            if (refCheckpoint != null) {
                String tempCpName = AsyncIndexUpdate.getTempCpName(AsyncIndexUpdate.this.name);
                NodeBuilder async = builder.child(AsyncIndexUpdate.ASYNC);
                async.setProperty(this.newIndexTaskName, refCheckpoint);
                HashSet temps = Sets.newHashSet();
                for (String cp : AsyncIndexUpdate.getStrings(async, tempCpName)) {
                    if (cp.equals(refCheckpoint)) continue;
                    temps.add(cp);
                }
                async.setProperty(tempCpName, temps, Type.STRINGS);
                AsyncIndexUpdate.this.indexStats.setTempCheckpoints(temps);
            }
            HashSet updated = Sets.newHashSet();
            for (String path : this.paths) {
                NodeBuilder c = builder;
                for (String p : PathUtils.elements(path)) {
                    c = c.getChildNode(p);
                }
                if (!c.exists() || !AsyncIndexUpdate.this.name.equals(c.getString("async"))) continue;
                c.setProperty("async", this.newIndexTaskName);
                updated.add(path);
            }
            if (!updated.isEmpty()) {
                AsyncIndexUpdate.mergeWithConcurrencyCheck(AsyncIndexUpdate.this.store, builder, refCheckpoint, lease, AsyncIndexUpdate.this.name);
                log.info("[{}] Successfully split index definitions {} to async task named {} with referenced checkpoint {}.", new Object[]{AsyncIndexUpdate.this.name, updated, this.newIndexTaskName, refCheckpoint});
                this.lastReferencedCp = refCheckpoint;
            }
            this.paths = null;
            this.newIndexTaskName = null;
        }

        public String getLastReferencedCp() {
            return this.lastReferencedCp;
        }

        void registerAsyncIndexer(String newTask, long delayInSeconds) {
            if (this.registeredTasks.contains(newTask)) {
                log.warn("[{}] Task {} is already registered.", (Object)AsyncIndexUpdate.this.name, (Object)newTask);
                return;
            }
            if (AsyncIndexUpdate.this.mbeanRegistration != null) {
                log.info("[{}] Registering a new indexing task {} running each {} seconds.", new Object[]{AsyncIndexUpdate.this.name, newTask, delayInSeconds});
                AsyncIndexUpdate task = new AsyncIndexUpdate(newTask, AsyncIndexUpdate.this.store, AsyncIndexUpdate.this.provider);
                AsyncIndexUpdate.this.mbeanRegistration.registerAsyncIndexer(task, delayInSeconds);
                this.registeredTasks.add(newTask);
            }
        }
    }

    static class DefaultMissingIndexProviderStrategy
    extends IndexUpdate.MissingIndexProviderStrategy {
        DefaultMissingIndexProviderStrategy() {
        }

        @Override
        public void onMissingIndex(String type, NodeBuilder definition, String path) throws CommitFailedException {
            if (this.isDisabled(type)) {
                return;
            }
            throw new CommitFailedException("Async", 2, "Missing index provider detected for type [" + type + "] on index [" + path + "]");
        }
    }

    final class AsyncIndexStats
    extends AnnotatedStandardMBean
    implements IndexStatsMBean,
    Runnable {
        private String start;
        private String done;
        private String status;
        private String referenceCp;
        private String processedCp;
        private Set<String> tempCps;
        private volatile boolean isPaused;
        private volatile long updates;
        private final Stopwatch watch;
        private final ExecutionStats execStats;
        private volatile boolean failing;
        private long latestErrorWarn;
        private String failingSince;
        private String latestError;
        private String latestErrorTime;
        private long consecutiveFailures;

        protected AsyncIndexStats() {
            super(IndexStatsMBean.class);
            this.start = "";
            this.done = "";
            this.status = "init";
            this.referenceCp = "";
            this.processedCp = "";
            this.tempCps = new HashSet<String>();
            this.watch = Stopwatch.createUnstarted();
            this.execStats = new ExecutionStats();
            this.failing = false;
            this.latestErrorWarn = 0L;
            this.failingSince = "";
            this.latestError = null;
            this.latestErrorTime = "";
            this.consecutiveFailures = 0L;
        }

        public void start(String now) {
            this.status = "running";
            this.start = now;
            this.done = "";
            if (this.watch.isRunning()) {
                this.watch.reset();
            }
            this.watch.start();
        }

        public void done(String now) {
            this.status = "done";
            this.done = now;
            if (this.watch.isRunning()) {
                this.watch.stop();
            }
            this.execStats.incrementCounter();
            this.execStats.recordExecution(this.watch.elapsed(TimeUnit.MILLISECONDS), this.updates);
            this.watch.reset();
        }

        public void failed(Exception e) {
            if (e == INTERRUPTED) {
                log.info("[{}] The index update interrupted", (Object)AsyncIndexUpdate.this.name);
                log.debug("[{}] The index update interrupted", (Object)AsyncIndexUpdate.this.name, (Object)e);
                return;
            }
            this.latestError = Throwables.getStackTraceAsString((Throwable)e);
            this.latestErrorTime = AsyncIndexUpdate.now();
            ++this.consecutiveFailures;
            if (!this.failing) {
                this.failing = true;
                this.failingSince = this.latestErrorTime;
                this.latestErrorWarn = System.currentTimeMillis();
                log.warn("[{}] The index update failed", (Object)AsyncIndexUpdate.this.name, (Object)e);
            } else {
                boolean warn;
                boolean bl = warn = System.currentTimeMillis() - this.latestErrorWarn > ERROR_WARN_INTERVAL;
                if (warn) {
                    this.latestErrorWarn = System.currentTimeMillis();
                    log.warn("[{}] The index update is still failing", (Object)AsyncIndexUpdate.this.name, (Object)e);
                } else {
                    log.debug("[{}] The index update is still failing", (Object)AsyncIndexUpdate.this.name, (Object)e);
                }
            }
        }

        public void fixed() {
            log.info("[{}] Index update no longer fails", (Object)AsyncIndexUpdate.this.name);
            this.failing = false;
            this.failingSince = "";
            this.consecutiveFailures = 0L;
            this.latestErrorWarn = 0L;
            this.latestError = null;
            this.latestErrorTime = "";
        }

        @Override
        public boolean isFailing() {
            return this.failing;
        }

        @Override
        public String getStart() {
            return this.start;
        }

        @Override
        public String getDone() {
            return this.done;
        }

        @Override
        public String getStatus() {
            return this.status;
        }

        @Override
        public String getLastIndexedTime() {
            PropertyState ps = AsyncIndexUpdate.this.store.getRoot().getChildNode(AsyncIndexUpdate.ASYNC).getProperty(AsyncIndexUpdate.this.lastIndexedTo);
            return ps != null ? ps.getValue(Type.STRING) : null;
        }

        @Override
        public void pause() {
            log.debug("[{}] Pausing the async indexer", (Object)AsyncIndexUpdate.this.name);
            this.isPaused = true;
        }

        @Override
        public void resume() {
            log.debug("[{}] Resuming the async indexer", (Object)AsyncIndexUpdate.this.name);
            this.isPaused = false;
        }

        @Override
        public boolean isPaused() {
            return this.isPaused;
        }

        void resetUpdates() {
            this.updates = 0L;
        }

        long incUpdates() {
            ++this.updates;
            return this.updates;
        }

        @Override
        public long getUpdates() {
            return this.updates;
        }

        void setReferenceCheckpoint(String checkpoint) {
            this.referenceCp = checkpoint;
        }

        @Override
        public String getReferenceCheckpoint() {
            return this.referenceCp;
        }

        void setProcessedCheckpoint(String checkpoint) {
            this.processedCp = checkpoint;
        }

        @Override
        public String getProcessedCheckpoint() {
            return this.processedCp;
        }

        void setTempCheckpoints(Set<String> tempCheckpoints) {
            this.tempCps = tempCheckpoints;
        }

        void releaseTempCheckpoint(String tempCheckpoint) {
            this.tempCps.remove(tempCheckpoint);
        }

        @Override
        public String getTemporaryCheckpoints() {
            return this.tempCps.toString();
        }

        @Override
        public CompositeData getExecutionCount() {
            return this.execStats.getExecutionCount();
        }

        @Override
        public CompositeData getExecutionTime() {
            return this.execStats.getExecutionTime();
        }

        @Override
        public CompositeData getIndexedNodesCount() {
            return this.execStats.getIndexedNodesCount();
        }

        @Override
        public CompositeData getConsolidatedExecutionStats() {
            return this.execStats.getConsolidatedStats();
        }

        @Override
        public void resetConsolidatedExecutionStats() {
            this.execStats.resetConsolidatedStats();
        }

        public String toString() {
            return "AsyncIndexStats [start=" + this.start + ", done=" + this.done + ", status=" + this.status + ", paused=" + this.isPaused + ", failing=" + this.failing + ", failingSince=" + this.failingSince + ", consecutiveFailures=" + this.consecutiveFailures + ", updates=" + this.updates + ", referenceCheckpoint=" + this.referenceCp + ", processedCheckpoint=" + this.processedCp + " ,tempCheckpoints=" + this.tempCps + ", latestErrorTime=" + this.latestErrorTime + ", latestError=" + this.latestError + " ]";
        }

        @Override
        public void run() {
            this.execStats.recordTick();
        }

        @Override
        public void splitIndexingTask(String paths, String newIndexTaskName) {
            this.splitIndexingTask(Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)paths)), newIndexTaskName);
        }

        private void splitIndexingTask(Set<String> paths, String newIndexTaskName) {
            AsyncIndexUpdate.this.taskSplitter.registerSplit(paths, newIndexTaskName);
        }

        @Override
        public void registerAsyncIndexer(String name, long delayInSeconds) {
            AsyncIndexUpdate.this.taskSplitter.registerAsyncIndexer(name, delayInSeconds);
        }

        @Override
        public String getFailingSince() {
            return this.failingSince;
        }

        @Override
        public long getConsecutiveFailedExecutions() {
            return this.consecutiveFailures;
        }

        @Override
        public String getLatestError() {
            return this.latestError;
        }

        @Override
        public String getLatestErrorTime() {
            return this.latestErrorTime;
        }

        private class ExecutionStats {
            private final TimeSeriesRecorder execCounter;
            private final TimeSeriesRecorder execTimer;
            private final TimeSeriesRecorder indexedNodesCounter;
            private final AtomicLong consolidatedExecTime = new AtomicLong();
            private final AtomicInteger consolidatedExecRuns = new AtomicInteger();
            private final AtomicLong consolidatedNodes = new AtomicLong();
            private final String[] names = new String[]{"Executions", "Execution Time", "Nodes"};
            private CompositeType consolidatedType;

            private ExecutionStats() {
                this.execCounter = new TimeSeriesRecorder(true);
                this.execTimer = new TimeSeriesRecorder(true);
                this.indexedNodesCounter = new TimeSeriesRecorder(true);
                try {
                    this.consolidatedType = new CompositeType("ConsolidatedStats", "Consolidated stats", this.names, this.names, new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG});
                }
                catch (OpenDataException e) {
                    log.warn("[{}] Error in creating CompositeType for consolidated stats", (Object)AsyncIndexUpdate.this.name, (Object)e);
                }
            }

            private void incrementCounter() {
                this.execCounter.getCounter().incrementAndGet();
                this.consolidatedExecRuns.incrementAndGet();
            }

            private void recordExecution(long time, long updates) {
                this.execTimer.getCounter().addAndGet(time);
                this.indexedNodesCounter.getCounter().addAndGet(updates);
                this.consolidatedExecTime.addAndGet(time);
                this.consolidatedNodes.addAndGet(updates);
            }

            private CompositeData getExecutionCount() {
                return TimeSeriesStatsUtil.asCompositeData(this.execCounter, "ExecutionCount");
            }

            private CompositeData getExecutionTime() {
                return TimeSeriesStatsUtil.asCompositeData(this.execTimer, "ExecutionTime");
            }

            private CompositeData getIndexedNodesCount() {
                return TimeSeriesStatsUtil.asCompositeData(this.indexedNodesCounter, "ExecutionNodesCount");
            }

            private CompositeData getConsolidatedStats() {
                try {
                    Object[] values = new Long[]{this.consolidatedExecRuns.longValue(), this.consolidatedExecTime.longValue(), this.consolidatedNodes.longValue()};
                    return new CompositeDataSupport(this.consolidatedType, this.names, values);
                }
                catch (Exception e) {
                    log.error("[{}] Error retrieving consolidated stats", (Object)AsyncIndexUpdate.this.name, (Object)e);
                    return null;
                }
            }

            private void resetConsolidatedStats() {
                this.consolidatedExecRuns.set(0);
                this.consolidatedExecTime.set(0L);
                this.consolidatedNodes.set(0L);
            }

            private void recordTick() {
                this.execCounter.recordOneSecond();
                this.execTimer.recordOneSecond();
                this.indexedNodesCounter.recordOneSecond();
            }
        }
    }

    protected static class AsyncUpdateCallback
    implements IndexUpdateCallback {
        private final NodeStore store;
        private final String checkpoint;
        private final String afterCheckpoint;
        private final String tempCpName;
        private final long leaseTimeOut;
        private final String name;
        private final String leaseName;
        private final AsyncIndexStats indexStats;
        private final AtomicBoolean forcedStop;
        private long lease;

        public AsyncUpdateCallback(NodeStore store, String name, long leaseTimeOut, String checkpoint, String afterCheckpoint, AsyncIndexStats indexStats, AtomicBoolean forcedStop) {
            this.store = store;
            this.name = name;
            this.forcedStop = forcedStop;
            this.leaseTimeOut = leaseTimeOut;
            this.checkpoint = checkpoint;
            this.afterCheckpoint = afterCheckpoint;
            this.tempCpName = AsyncIndexUpdate.getTempCpName(name);
            this.indexStats = indexStats;
            this.leaseName = AsyncIndexUpdate.leasify(name);
        }

        protected void prepare() throws CommitFailedException {
            long now = System.currentTimeMillis();
            this.lease = now + 2L * this.leaseTimeOut;
            NodeState root = this.store.getRoot();
            long beforeLease = root.getChildNode(AsyncIndexUpdate.ASYNC).getLong(this.leaseName);
            if (beforeLease > now) {
                throw CONCURRENT_UPDATE;
            }
            NodeBuilder builder = root.builder();
            NodeBuilder async = builder.child(AsyncIndexUpdate.ASYNC);
            async.setProperty(this.leaseName, this.lease);
            AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, builder, this.checkpoint, beforeLease, this.name);
            this.updateTempCheckpoints(async, this.checkpoint, this.afterCheckpoint);
            AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, builder, this.checkpoint, this.lease, this.name);
            this.indexStats.resetUpdates();
        }

        private void updateTempCheckpoints(NodeBuilder async, String checkpoint, String afterCheckpoint) {
            this.indexStats.setReferenceCheckpoint(checkpoint);
            this.indexStats.setProcessedCheckpoint(afterCheckpoint);
            HashSet temps = Sets.newHashSet();
            for (String cp : AsyncIndexUpdate.getStrings(async, this.tempCpName)) {
                if (cp.equals(checkpoint)) {
                    temps.add(cp);
                    continue;
                }
                boolean released = this.store.release(cp);
                log.debug("[{}] Releasing temporary checkpoint {}: {}", new Object[]{this.name, cp, released});
                if (released) continue;
                temps.add(cp);
            }
            temps.add(afterCheckpoint);
            async.setProperty(this.tempCpName, temps, Type.STRINGS);
            this.indexStats.setTempCheckpoints(temps);
        }

        boolean isDirty() {
            return this.indexStats.getUpdates() > 0L;
        }

        void close() throws CommitFailedException {
            NodeBuilder builder = this.store.getRoot().builder();
            NodeBuilder async = builder.child(AsyncIndexUpdate.ASYNC);
            async.removeProperty(this.leaseName);
            AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, builder, async.getString(this.name), this.lease, this.name);
        }

        @Override
        public void indexUpdate() throws CommitFailedException {
            long now;
            if (this.forcedStop.get()) {
                throw INTERRUPTED;
            }
            if (this.indexStats.incUpdates() % 100L == 0L && (now = System.currentTimeMillis()) + this.leaseTimeOut > this.lease) {
                long newLease = now + 2L * this.leaseTimeOut;
                NodeBuilder builder = this.store.getRoot().builder();
                builder.child(AsyncIndexUpdate.ASYNC).setProperty(this.leaseName, newLease);
                AsyncIndexUpdate.mergeWithConcurrencyCheck(this.store, builder, this.checkpoint, this.lease, this.name);
                this.lease = newLease;
            }
        }
    }
}

