/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class PathFilter {
    private static final Collection<String> INCLUDE_ROOT = Collections.singletonList("/");
    public static final String PROP_INCLUDED_PATHS = "includedPaths";
    public static final String PROP_EXCLUDED_PATHS = "excludedPaths";
    private static final PathFilter ALL = new PathFilter(INCLUDE_ROOT, (Iterable)Collections.emptyList()){

        @Override
        public Result filter(@Nonnull String path) {
            return Result.INCLUDE;
        }
    };
    private final String[] includedPaths;
    private final String[] excludedPaths;

    public static PathFilter from(@Nonnull NodeBuilder defn) {
        if (!defn.hasProperty(PROP_EXCLUDED_PATHS) && !defn.hasProperty(PROP_INCLUDED_PATHS)) {
            return ALL;
        }
        return new PathFilter(PathFilter.getStrings(defn, PROP_INCLUDED_PATHS, INCLUDE_ROOT), PathFilter.getStrings(defn, PROP_EXCLUDED_PATHS, Collections.<String>emptyList()));
    }

    public PathFilter(Iterable<String> includes, Iterable<String> excludes) {
        HashSet includeCopy = Sets.newHashSet(includes);
        HashSet excludeCopy = Sets.newHashSet(excludes);
        PathUtils.unifyInExcludes(includeCopy, excludeCopy);
        Preconditions.checkState((!includeCopy.isEmpty() ? 1 : 0) != 0, (String)"No valid include provided. Includes %s, Excludes %s", (Object[])new Object[]{includes, excludes});
        this.includedPaths = includeCopy.toArray(new String[includeCopy.size()]);
        this.excludedPaths = excludeCopy.toArray(new String[excludeCopy.size()]);
    }

    public Result filter(@Nonnull String path) {
        for (String excludedPath : this.excludedPaths) {
            if (!excludedPath.equals(path) && !PathUtils.isAncestor(excludedPath, path)) continue;
            return Result.EXCLUDE;
        }
        for (String includedPath : this.includedPaths) {
            if (!includedPath.equals(path) && !PathUtils.isAncestor(includedPath, path)) continue;
            return Result.INCLUDE;
        }
        for (String includedPath : this.includedPaths) {
            if (!PathUtils.isAncestor(path, includedPath)) continue;
            return Result.TRAVERSE;
        }
        return Result.EXCLUDE;
    }

    public String toString() {
        return "PathFilter{includedPaths=" + Arrays.toString(this.includedPaths) + ", excludedPaths=" + Arrays.toString(this.excludedPaths) + '}';
    }

    private static Iterable<String> getStrings(NodeBuilder builder, String propertyName, Collection<String> defaultVal) {
        PropertyState property = builder.getProperty(propertyName);
        if (property != null && property.getType() == Type.STRINGS) {
            return property.getValue(Type.STRINGS);
        }
        return defaultVal;
    }

    public boolean areAllDescendantsIncluded(String path) {
        for (String excludedPath : this.excludedPaths) {
            if (!excludedPath.equals(path) && !PathUtils.isAncestor(excludedPath, path) && !PathUtils.isAncestor(path, excludedPath)) continue;
            return false;
        }
        for (String includedPath : this.includedPaths) {
            if (!includedPath.equals(path) && !PathUtils.isAncestor(includedPath, path)) continue;
            return true;
        }
        return false;
    }

    public static enum Result {
        INCLUDE,
        EXCLUDE,
        TRAVERSE;

    }
}

