/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.ArrayBasedBlob;
import org.apache.jackrabbit.oak.plugins.memory.MultiPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;

public class MultiBinaryPropertyState
extends MultiPropertyState<Blob> {
    public MultiBinaryPropertyState(String name, Iterable<Blob> values) {
        super(name, values);
    }

    public static PropertyState binaryPropertyFromBlob(String name, Iterable<Blob> values) {
        return new MultiBinaryPropertyState(name, values);
    }

    public static PropertyState binaryPropertyFromArray(String name, Iterable<byte[]> values) {
        ArrayList blobs = Lists.newArrayList();
        for (byte[] data : values) {
            blobs.add(new ArrayBasedBlob(data));
        }
        return new MultiBinaryPropertyState(name, blobs);
    }

    @Override
    public Conversions.Converter getConverter(Blob value) {
        return Conversions.convert(value);
    }

    @Override
    public Type<?> getType() {
        return Type.BINARIES;
    }
}

