/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.metric;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.apache.jackrabbit.oak.plugins.metric.MetricStatisticsProvider;
import org.apache.jackrabbit.oak.stats.DefaultStatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak StatisticsProviderFactory", description="Creates a statistics providers used by Oak. By default if checks if Metrics (See http://metrics.dropwizard.io) library is present then that is used. Otherwise it fallbacks to default")
public class StatisticsProviderFactory {
    private static final String TYPE_DEFAULT = "DEFAULT";
    private static final String TYPE_METRIC = "METRIC";
    private static final String TYPE_NONE = "NONE";
    private static final String TYPE_AUTO = "AUTO";
    private static final String METRIC_PROVIDER_CLASS = "com.codahale.metrics.MetricRegistry";
    @Property(value={"AUTO"}, options={@PropertyOption(name="DEFAULT", value="DEFAULT"), @PropertyOption(name="METRIC", value="METRIC"), @PropertyOption(name="NONE", value="NONE")})
    static final String PROVIDER_TYPE = "providerType";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private MBeanServer server;
    private StatisticsProvider statisticsProvider;
    private List<ServiceRegistration> regs = Lists.newArrayList();
    private ScheduledExecutorService executor;
    private BundleContext bundleContext;

    @Activate
    private void activate(BundleContext context, Map<String, Object> config) {
        this.bundleContext = context;
        String providerType = PropertiesUtil.toString(config.get(PROVIDER_TYPE), TYPE_AUTO);
        this.statisticsProvider = this.createProvider(providerType);
        if (this.statisticsProvider != null) {
            this.regs.add(context.registerService(StatisticsProvider.class.getName(), (Object)this.statisticsProvider, null));
        }
    }

    @Deactivate
    private void deactivate() throws IOException {
        for (ServiceRegistration reg : this.regs) {
            reg.unregister();
        }
        this.regs.clear();
        if (this.statisticsProvider instanceof Closeable) {
            ((Closeable)((Object)this.statisticsProvider)).close();
        }
        new ExecutorCloser(this.executor).close();
    }

    private StatisticsProvider createProvider(String providerType) {
        if (TYPE_NONE.equals(providerType)) {
            this.log.info("No statistics provider created as {} option is selected", (Object)TYPE_NONE);
            return null;
        }
        this.executor = Executors.newSingleThreadScheduledExecutor();
        String effectiveProviderType = providerType;
        if (TYPE_AUTO.equals(providerType) && this.isMetricSupportPresent()) {
            effectiveProviderType = TYPE_METRIC;
        }
        if (TYPE_METRIC.equals(effectiveProviderType)) {
            this.log.info("Using MetricsStatisticsProvider");
            return this.createMetricsProvider(this.executor);
        }
        this.log.info("Using DefaultStatisticsProvider");
        return new DefaultStatisticsProvider(this.executor);
    }

    private StatisticsProvider createMetricsProvider(ScheduledExecutorService executor) {
        MetricStatisticsProvider metricProvider = new MetricStatisticsProvider(this.server, executor);
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("name", "oak");
        this.regs.add(this.bundleContext.registerService(METRIC_PROVIDER_CLASS, (Object)metricProvider.getRegistry(), dictionary));
        return metricProvider;
    }

    private boolean isMetricSupportPresent() {
        try {
            StatisticsProviderFactory.class.getClassLoader().loadClass(METRIC_PROVIDER_CLASS);
        }
        catch (Throwable e) {
            this.log.debug("Cannot load optional Metrics library support", e);
            return false;
        }
        return true;
    }

    protected void bindServer(MBeanServer mBeanServer) {
        this.server = mBeanServer;
    }

    protected void unbindServer(MBeanServer mBeanServer) {
        if (this.server == mBeanServer) {
            this.server = null;
        }
    }
}

