/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefWriter;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.JcrNameParser;
import org.apache.jackrabbit.oak.namepath.JcrPathParser;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.nodetype.AbstractTypeDefinition;
import org.apache.jackrabbit.oak.plugins.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.oak.plugins.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.Constraints;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeTypeImpl
extends AbstractTypeDefinition
implements NodeType {
    private static final Logger log = LoggerFactory.getLogger(NodeTypeImpl.class);
    private static final PropertyDefinition[] NO_PROPERTY_DEFINITIONS = new PropertyDefinition[0];
    private static final NodeDefinition[] NO_NODE_DEFINITIONS = new NodeDefinition[0];
    private static final NodeType[] NO_NODE_TYPES = new NodeType[0];
    private static final String[] NO_NAMES = new String[0];

    NodeTypeImpl(Tree type, NamePathMapper mapper) {
        super(type, mapper);
    }

    private String getOakName() {
        return this.getOakName(this.definition);
    }

    private String getOakName(Tree tree) {
        PropertyState property = tree.getProperty("jcr:nodeTypeName");
        if (property != null) {
            return property.getValue(Type.NAME);
        }
        return tree.getName();
    }

    public String getName() {
        return this.mapper.getJcrName(this.getOakName());
    }

    public String[] getDeclaredSupertypeNames() {
        String[] names = this.getNames("jcr:supertypes");
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                names[i] = this.mapper.getJcrName(names[i]);
            }
        } else {
            names = NO_NAMES;
        }
        return names;
    }

    public boolean isAbstract() {
        return this.getBoolean("jcr:isAbstract");
    }

    public boolean isMixin() {
        return this.getBoolean("jcr:isMixin");
    }

    public boolean hasOrderableChildNodes() {
        return this.getBoolean("jcr:hasOrderableChildNodes");
    }

    public boolean isQueryable() {
        return this.getBoolean("jcr:isQueryable");
    }

    public String getPrimaryItemName() {
        String oakName = this.getName("jcr:primaryItemName");
        if (oakName != null) {
            return this.mapper.getJcrName(oakName);
        }
        return null;
    }

    @Nonnull
    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        TreeMap definitions = Maps.newTreeMap();
        for (Tree child : Iterables.filter(this.definition.getChildren(), (Predicate)PrimaryTypePredicate.PROPERTY_DEF_PREDICATE)) {
            definitions.put(NodeTypeImpl.getIndex(child), new PropertyDefinitionImpl(child, this, this.mapper));
        }
        return definitions.values().toArray(NO_PROPERTY_DEFINITIONS);
    }

    @Nonnull
    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        TreeMap definitions = Maps.newTreeMap();
        for (Tree child : Iterables.filter(this.definition.getChildren(), (Predicate)PrimaryTypePredicate.CHILDNODE_DEF_PREDICATE)) {
            definitions.put(NodeTypeImpl.getIndex(child), new NodeDefinitionImpl(child, this, this.mapper));
        }
        return definitions.values().toArray(NO_NODE_DEFINITIONS);
    }

    public NodeType[] getSupertypes() {
        LinkedHashMap supertypes = Maps.newLinkedHashMap();
        this.addSupertypes(this.definition, supertypes);
        return supertypes.values().toArray(NO_NODE_TYPES);
    }

    private void addSupertypes(Tree type, Map<String, NodeType> supertypes) {
        PropertyState property = type.getProperty("jcr:supertypes");
        if (property != null) {
            Tree root = this.definition.getParent();
            for (String oakName : property.getValue(Type.NAMES)) {
                if (supertypes.containsKey(oakName)) continue;
                Tree supertype = root.getChild(oakName);
                Preconditions.checkState((boolean)supertype.exists());
                supertypes.put(oakName, new NodeTypeImpl(supertype, this.mapper));
                this.addSupertypes(supertype, supertypes);
            }
        }
    }

    public NodeType[] getDeclaredSupertypes() {
        NodeType[] supertypes = NO_NODE_TYPES;
        String[] oakNames = this.getNames("jcr:supertypes");
        if (oakNames != null && oakNames.length > 0) {
            supertypes = new NodeType[oakNames.length];
            Tree root = this.definition.getParent();
            for (int i = 0; i < oakNames.length; ++i) {
                Tree type = root.getChild(oakNames[i]);
                Preconditions.checkState((boolean)type.exists());
                supertypes[i] = new NodeTypeImpl(type, this.mapper);
            }
        }
        return supertypes;
    }

    public NodeTypeIterator getSubtypes() {
        HashMap inheritance = Maps.newHashMap();
        Tree root = this.definition.getParent();
        for (Tree child : root.getChildren()) {
            String oakName = this.getOakName(child);
            PropertyState supertypes = child.getProperty("jcr:supertypes");
            if (supertypes == null) continue;
            for (String supername : supertypes.getValue(Type.NAMES)) {
                Set subtypes = (Set)inheritance.get(supername);
                if (subtypes == null) {
                    subtypes = Sets.newHashSet();
                    inheritance.put(supername, subtypes);
                }
                subtypes.add(oakName);
            }
        }
        HashMap subtypes = Maps.newHashMap();
        this.addSubtypes(this.getOakName(), subtypes, root, inheritance);
        return new NodeTypeIteratorAdapter(subtypes.values());
    }

    private void addSubtypes(String typeName, Map<String, NodeType> subtypes, Tree root, Map<String, Set<String>> inheritance) {
        Set<String> subnames = inheritance.get(typeName);
        if (subnames != null) {
            for (String subname : subnames) {
                if (subtypes.containsKey(subname)) continue;
                Tree tree = root.getChild(subname);
                subtypes.put(subname, new NodeTypeImpl(tree, this.mapper));
            }
        }
    }

    public NodeTypeIterator getDeclaredSubtypes() {
        ArrayList subtypes = Lists.newArrayList();
        String oakName = this.getOakName();
        Tree root = this.definition.getParent();
        block0: for (Tree child : root.getChildren()) {
            PropertyState supertypes = child.getProperty("jcr:supertypes");
            if (supertypes == null) continue;
            for (String name : supertypes.getValue(Type.NAMES)) {
                if (!oakName.equals(name)) continue;
                subtypes.add(new NodeTypeImpl(child, this.mapper));
                continue block0;
            }
        }
        return new NodeTypeIteratorAdapter(subtypes);
    }

    public boolean isNodeType(String nodeTypeName) {
        String oakName = this.mapper.getOakNameOrNull(nodeTypeName);
        return this.internalIsNodeType(oakName);
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        Collection<PropertyDefinition> definitions = this.internalGetPropertyDefinitions();
        return definitions.toArray(new PropertyDefinition[definitions.size()]);
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        Collection<NodeDefinition> definitions = this.internalGetChildDefinitions();
        return definitions.toArray(new NodeDefinition[definitions.size()]);
    }

    public boolean canSetProperty(String propertyName, Value value) {
        if (value == null) {
            return this.canRemoveProperty(propertyName);
        }
        try {
            EffectiveNodeType effective = new EffectiveNodeType(this, this.getManager());
            PropertyDefinition def = effective.getPropertyDefinition(propertyName, false, value.getType(), false);
            return !def.isProtected() && NodeTypeImpl.meetsTypeConstraints(value, def.getRequiredType()) && NodeTypeImpl.meetsValueConstraints(value, def.getValueConstraints());
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
            return false;
        }
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        if (values == null) {
            return this.canRemoveProperty(propertyName);
        }
        try {
            int type = values.length == 0 ? 1 : values[0].getType();
            EffectiveNodeType effective = new EffectiveNodeType(this, this.getManager());
            PropertyDefinition def = effective.getPropertyDefinition(propertyName, true, type, false);
            return !def.isProtected() && NodeTypeImpl.meetsTypeConstraints(values, def.getRequiredType()) && NodeTypeImpl.meetsValueConstraints(values, def.getValueConstraints());
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
            return false;
        }
    }

    public boolean canAddChildNode(String childNodeName) {
        for (NodeDefinition definition : this.getChildNodeDefinitions()) {
            String name = definition.getName();
            if (!this.matches(childNodeName, name) && !"*".equals(name)) continue;
            return !definition.isProtected() && definition.getDefaultPrimaryType() != null;
        }
        return false;
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        NodeType type;
        try {
            type = this.getManager().getNodeType(nodeTypeName);
            if (type.isAbstract()) {
                return false;
            }
        }
        catch (NoSuchNodeTypeException e) {
            return false;
        }
        catch (RepositoryException e) {
            log.warn("Unable to access node type " + nodeTypeName, (Throwable)e);
            return false;
        }
        for (NodeDefinition definition : this.getChildNodeDefinitions()) {
            String name = definition.getName();
            if (!this.matches(childNodeName, name) && !"*".equals(name)) continue;
            if (definition.isProtected()) {
                return false;
            }
            for (String required : definition.getRequiredPrimaryTypeNames()) {
                if (!type.isNodeType(required)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canRemoveItem(String itemName) {
        ArrayList definitions = Lists.newArrayList();
        definitions.addAll(Arrays.asList(this.getChildNodeDefinitions()));
        definitions.addAll(Arrays.asList(this.getPropertyDefinitions()));
        return this.internalCanRemoveItem(itemName, definitions);
    }

    public boolean canRemoveNode(String nodeName) {
        return this.internalCanRemoveItem(nodeName, Arrays.asList(this.getChildNodeDefinitions()));
    }

    public boolean canRemoveProperty(String propertyName) {
        return this.internalCanRemoveItem(propertyName, Arrays.asList(this.getPropertyDefinitions()));
    }

    private static String getCnd(NodeTypeDefinition def) {
        StringWriter out = new StringWriter();
        CompactNodeTypeDefWriter cndWriter = new CompactNodeTypeDefWriter((Writer)out, new CompactNodeTypeDefWriter.NamespaceMapping(){

            @Override
            public String getNamespaceURI(String s) {
                return s;
            }
        }, false);
        try {
            cndWriter.write(def);
        }
        catch (IOException e) {
            log.error("Error generating CND of " + def, (Throwable)e);
            throw new IllegalStateException(e);
        }
        return out.toString();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof NodeType && NodeTypeImpl.getCnd((NodeTypeDefinition)this).equals(NodeTypeImpl.getCnd((NodeTypeDefinition)((NodeType)o)));
    }

    public int hashCode() {
        return NodeTypeImpl.getCnd((NodeTypeDefinition)this).hashCode();
    }

    private boolean internalCanRemoveItem(String itemName, Iterable<? extends ItemDefinition> definitions) {
        for (ItemDefinition itemDefinition : definitions) {
            String name = itemDefinition.getName();
            if (!this.matches(itemName, name) || !itemDefinition.isMandatory() && !itemDefinition.isProtected()) continue;
            return false;
        }
        return definitions.iterator().hasNext();
    }

    private ReadOnlyNodeTypeManager getManager() {
        final Tree types = this.definition.getParent();
        return new ReadOnlyNodeTypeManager(){

            @Override
            @CheckForNull
            protected Tree getTypes() {
                return types;
            }
        };
    }

    boolean internalIsNodeType(String oakName) {
        if (this.getOakName().equals(oakName)) {
            return true;
        }
        for (NodeType type : this.getDeclaredSupertypes()) {
            if (!((NodeTypeImpl)type).internalIsNodeType(oakName)) continue;
            return true;
        }
        return false;
    }

    Collection<NodeDefinition> internalGetChildDefinitions() {
        ArrayList<NodeDefinition> definitions = new ArrayList<NodeDefinition>();
        definitions.addAll(Arrays.asList(this.getDeclaredChildNodeDefinitions()));
        for (NodeType type : this.getSupertypes()) {
            definitions.addAll(Arrays.asList(type.getDeclaredChildNodeDefinitions()));
        }
        return definitions;
    }

    Collection<PropertyDefinition> internalGetPropertyDefinitions() {
        ArrayList<PropertyDefinition> definitions = new ArrayList<PropertyDefinition>();
        definitions.addAll(Arrays.asList(this.getDeclaredPropertyDefinitions()));
        for (NodeType type : this.getSupertypes()) {
            definitions.addAll(Arrays.asList(type.getDeclaredPropertyDefinitions()));
        }
        return definitions;
    }

    List<PropertyDefinition> getDeclaredNamedPropertyDefinitions(String oakName) {
        String escapedName = oakName;
        if ("jcr:primaryType".equals(oakName)) {
            escapedName = "rep:primaryType";
        } else if ("jcr:mixinTypes".equals(oakName)) {
            escapedName = "rep:mixinTypes";
        } else if ("jcr:uuid".equals(oakName)) {
            escapedName = "rep:uuid";
        }
        return this.getDeclaredPropertyDefs(this.definition.getChild("rep:namedPropertyDefinitions").getChild(escapedName));
    }

    List<PropertyDefinition> getDeclaredResidualPropertyDefinitions() {
        return this.getDeclaredPropertyDefs(this.definition.getChild("rep:residualPropertyDefinitions"));
    }

    List<NodeDefinition> getDeclaredNamedNodeDefinitions(String oakName) {
        return this.getDeclaredNodeDefs(this.definition.getChild("rep:namedChildNodeDefinitions").getChild(oakName));
    }

    List<NodeDefinition> getDeclaredResidualNodeDefinitions() {
        return this.getDeclaredNodeDefs(this.definition.getChild("rep:residualChildNodeDefinitions"));
    }

    private List<PropertyDefinition> getDeclaredPropertyDefs(Tree definitions) {
        if (definitions.exists()) {
            ArrayList list = Lists.newArrayList();
            String typeName = this.getOakName();
            for (Tree def : definitions.getChildren()) {
                String declaringTypeName = TreeUtil.getName(def, "rep:declaringNodeType");
                if (!typeName.equals(declaringTypeName)) continue;
                list.add(new PropertyDefinitionImpl(def, this, this.mapper));
            }
            return list;
        }
        return Collections.emptyList();
    }

    private List<NodeDefinition> getDeclaredNodeDefs(Tree defs) {
        if (defs.exists()) {
            ArrayList list = Lists.newArrayList();
            String typeName = this.getOakName();
            for (Tree def : defs.getChildren()) {
                String declaringTypeName = TreeUtil.getName(def, "rep:declaringNodeType");
                if (!typeName.equals(declaringTypeName)) continue;
                list.add(new NodeDefinitionImpl(def, this, this.mapper));
            }
            return list;
        }
        return Collections.emptyList();
    }

    private static boolean meetsTypeConstraints(Value value, int requiredType) {
        try {
            switch (requiredType) {
                case 1: {
                    value.getString();
                    return true;
                }
                case 2: {
                    value.getBinary();
                    return true;
                }
                case 3: {
                    value.getLong();
                    return true;
                }
                case 4: {
                    value.getDouble();
                    return true;
                }
                case 5: {
                    value.getDate();
                    return true;
                }
                case 6: {
                    value.getBoolean();
                    return true;
                }
                case 7: {
                    int type = value.getType();
                    return type != 4 && type != 3 && type != 6 && JcrNameParser.validate(value.getString());
                }
                case 8: {
                    int type = value.getType();
                    return type != 4 && type != 3 && type != 6 && JcrPathParser.validate(value.getString());
                }
                case 9: 
                case 10: {
                    return IdentifierManager.isValidUUID(value.getString());
                }
                case 11: {
                    new URI(value.getString());
                    return true;
                }
                case 12: {
                    value.getDecimal();
                    return true;
                }
                case 0: {
                    return true;
                }
            }
            log.warn("Invalid property type value: " + requiredType);
            return false;
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private static boolean meetsTypeConstraints(Value[] values, int requiredType) {
        for (Value value : values) {
            if (NodeTypeImpl.meetsTypeConstraints(value, requiredType)) continue;
            return false;
        }
        return true;
    }

    private static boolean meetsValueConstraints(Value value, String[] constraints) {
        if (constraints == null || constraints.length == 0) {
            return true;
        }
        for (String constraint : constraints) {
            if (!Constraints.valueConstraint(value.getType(), constraint).apply((Object)value)) continue;
            return true;
        }
        return false;
    }

    private static boolean meetsValueConstraints(Value[] values, String[] constraints) {
        if (constraints == null || constraints.length == 0) {
            return true;
        }
        for (Value value : values) {
            if (NodeTypeImpl.meetsValueConstraints(value, constraints)) continue;
            return false;
        }
        return true;
    }

    private static int getIndex(@Nonnull Tree tree) {
        String name = tree.getName();
        int i = name.lastIndexOf(91);
        return i == -1 ? 1 : Integer.valueOf(name.substring(i + 1, name.lastIndexOf(93)));
    }

    private boolean matches(String childNodeName, String name) {
        String oakChildName = this.mapper.getOakNameOrNull(childNodeName);
        String oakName = this.mapper.getOakNameOrNull(name);
        return oakChildName != null && oakChildName.startsWith(oakName);
    }

    private static final class PrimaryTypePredicate
    implements Predicate<Tree> {
        private static final PrimaryTypePredicate PROPERTY_DEF_PREDICATE = new PrimaryTypePredicate("nt:propertyDefinition");
        private static final PrimaryTypePredicate CHILDNODE_DEF_PREDICATE = new PrimaryTypePredicate("nt:childNodeDefinition");
        private final String primaryTypeName;

        private PrimaryTypePredicate(@Nonnull String primaryTypeName) {
            this.primaryTypeName = primaryTypeName;
        }

        public boolean apply(Tree tree) {
            return this.primaryTypeName.equals(TreeUtil.getPrimaryTypeName(tree));
        }
    }
}

