/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import java.util.Collections;
import java.util.UUID;
import javax.jcr.Value;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.identifier.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStoreService;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={SegmentDiscoveryLiteService.class})
public class SegmentDiscoveryLiteService {
    static final String COMPONENT_NAME = "org.apache.jackrabbit.oak.plugins.segment.SegmentDiscoveryLiteService";
    public static final String OAK_DISCOVERYLITE_CLUSTERVIEW = "oak.discoverylite.clusterview";
    private static final Logger logger = LoggerFactory.getLogger(SegmentDiscoveryLiteService.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private volatile NodeStore nodeStore;
    private final String runtimeClusterId = UUID.randomUUID().toString();

    private String getClusterViewAsDescriptorValue() {
        String clusterId = ClusterRepositoryInfo.getOrCreateId(this.nodeStore);
        return "{\"seq\":1,\"final\":true,\"me\":1,\"id\":\"" + clusterId + "\",\"active\":[1],\"deactivating\":[],\"inactive\":[]}";
    }

    @Activate
    public void activate(ComponentContext context) {
        logger.trace("activate: start");
        boolean weAreOnSegment = this.nodeStore instanceof SegmentNodeStore ? true : this.nodeStore instanceof SegmentNodeStoreService;
        if (!weAreOnSegment) {
            logger.info("activate: nodeStore is not a SegmentNodeStore, thus disabling: org.apache.jackrabbit.oak.plugins.segment.SegmentDiscoveryLiteService");
            context.disableComponent(COMPONENT_NAME);
            return;
        }
        if (context != null) {
            OsgiWhiteboard whiteboard = new OsgiWhiteboard(context.getBundleContext());
            whiteboard.register(Descriptors.class, new DiscoveryLiteDescriptor(), Collections.emptyMap());
        }
        logger.trace("activate: end");
    }

    protected void bindNodeStore(NodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    protected void unbindNodeStore(NodeStore nodeStore) {
        if (this.nodeStore == nodeStore) {
            this.nodeStore = null;
        }
    }

    private class DiscoveryLiteDescriptor
    implements Descriptors {
        final SimpleValueFactory factory = new SimpleValueFactory();

        private DiscoveryLiteDescriptor() {
        }

        @Override
        public String[] getKeys() {
            return new String[]{SegmentDiscoveryLiteService.OAK_DISCOVERYLITE_CLUSTERVIEW};
        }

        @Override
        public boolean isStandardDescriptor(String key) {
            return SegmentDiscoveryLiteService.OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key);
        }

        @Override
        public boolean isSingleValueDescriptor(String key) {
            return SegmentDiscoveryLiteService.OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key);
        }

        @Override
        public Value getValue(String key) {
            if (!SegmentDiscoveryLiteService.OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key)) {
                return null;
            }
            return this.factory.createValue(SegmentDiscoveryLiteService.this.getClusterViewAsDescriptorValue());
        }

        @Override
        public Value[] getValues(String key) {
            if (!SegmentDiscoveryLiteService.OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key)) {
                return null;
            }
            return new Value[]{this.getValue(key)};
        }
    }
}

