/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.plugins.tree.impl.NodeBuilderTree;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public final class TreeFactory {
    private TreeFactory() {
    }

    public static Tree createTree(@Nonnull NodeBuilder builder) {
        return new NodeBuilderTree("", builder);
    }

    public static Tree createReadOnlyTree(@Nonnull NodeState rootState) {
        return new ImmutableTree(rootState);
    }

    public static Tree createReadOnlyTree(@Nonnull Tree readOnlyParent, @Nonnull String childName, @Nonnull NodeState childState) {
        Preconditions.checkArgument((boolean)(readOnlyParent instanceof ImmutableTree));
        return new ImmutableTree((ImmutableTree)readOnlyParent, childName, childState);
    }
}

