/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.AccessControlValidator;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class AccessControlValidatorProvider
extends ValidatorProvider {
    private final SecurityProvider securityProvider;

    public AccessControlValidatorProvider(@Nonnull SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    @Override
    @Nonnull
    public Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        RestrictionProvider restrictionProvider = this.getConfig(AuthorizationConfiguration.class).getRestrictionProvider();
        Root root = RootFactory.createReadOnlyRoot(before);
        PrivilegeManager privilegeManager = this.getConfig(PrivilegeConfiguration.class).getPrivilegeManager(root, NamePathMapper.DEFAULT);
        PrivilegeBitsProvider privilegeBitsProvider = new PrivilegeBitsProvider(root);
        return new AccessControlValidator(after, privilegeManager, privilegeBitsProvider, restrictionProvider);
    }

    private <T> T getConfig(Class<T> configClass) {
        return this.securityProvider.getConfiguration(configClass);
    }
}

