/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.LongUtils;
import org.apache.jackrabbit.oak.security.authorization.permission.EntryPredicate;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntryCache;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntryProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;

class PermissionEntryProviderImpl
implements PermissionEntryProvider {
    public static final String EAGER_CACHE_SIZE_PARAM = "eagerCacheSize";
    private static final long DEFAULT_SIZE = 250L;
    private final Set<String> principalNames;
    private final Set<String> existingNames = new HashSet<String>();
    private final PermissionStore store;
    private final PermissionEntryCache cache;
    private final long maxSize;
    private Map<String, Collection<PermissionEntry>> pathEntryMap;

    PermissionEntryProviderImpl(@Nonnull PermissionStore store, @Nonnull PermissionEntryCache cache, @Nonnull Set<String> principalNames, @Nonnull ConfigurationParameters options) {
        this.store = store;
        this.cache = cache;
        this.principalNames = Collections.unmodifiableSet(principalNames);
        this.maxSize = options.getConfigValue(EAGER_CACHE_SIZE_PARAM, 250L);
        this.init();
    }

    private void init() {
        long cnt = 0L;
        this.existingNames.clear();
        for (String name : this.principalNames) {
            long n = this.cache.getNumEntries(this.store, name, this.maxSize);
            if (n > 0L) {
                this.existingNames.add(name);
            }
            if (cnt >= Long.MAX_VALUE) continue;
            if (Long.MAX_VALUE == n) {
                cnt = Long.MAX_VALUE;
                continue;
            }
            cnt = LongUtils.safeAdd(cnt, n);
        }
        if (cnt > 0L && cnt < this.maxSize) {
            this.pathEntryMap = new HashMap<String, Collection<PermissionEntry>>();
            for (String name : this.existingNames) {
                this.cache.load(this.store, this.pathEntryMap, name);
            }
        } else {
            this.pathEntryMap = null;
        }
    }

    @Override
    public void flush() {
        this.cache.flush(this.principalNames);
        this.init();
    }

    @Override
    @Nonnull
    public Iterator<PermissionEntry> getEntryIterator(@Nonnull EntryPredicate predicate) {
        if (this.existingNames.isEmpty()) {
            return Iterators.emptyIterator();
        }
        return new EntryIterator(predicate);
    }

    @Override
    @Nonnull
    public Collection<PermissionEntry> getEntries(@Nonnull Tree accessControlledTree) {
        if (this.existingNames.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.pathEntryMap != null) {
            Collection<PermissionEntry> entries = this.pathEntryMap.get(accessControlledTree.getPath());
            return entries != null ? entries : Collections.emptyList();
        }
        return accessControlledTree.hasChild("rep:policy") ? this.loadEntries(accessControlledTree.getPath()) : Collections.emptyList();
    }

    @Nonnull
    private Collection<PermissionEntry> getEntries(@Nonnull String path) {
        if (this.existingNames.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.pathEntryMap != null) {
            Collection<PermissionEntry> entries = this.pathEntryMap.get(path);
            return entries != null ? entries : Collections.emptyList();
        }
        return this.loadEntries(path);
    }

    @Nonnull
    private Collection<PermissionEntry> loadEntries(@Nonnull String path) {
        TreeSet<PermissionEntry> ret = new TreeSet<PermissionEntry>();
        for (String name : this.existingNames) {
            this.cache.load(this.store, ret, name, path);
        }
        return ret;
    }

    private final class EntryIterator
    extends AbstractLazyIterator<PermissionEntry> {
        private final EntryPredicate predicate;
        private Iterator<PermissionEntry> nextEntries = Iterators.emptyIterator();
        private String path;

        private EntryIterator(EntryPredicate predicate) {
            this.predicate = predicate;
            this.path = Strings.nullToEmpty((String)predicate.getPath());
        }

        @Override
        protected PermissionEntry getNext() {
            PermissionEntry next = null;
            while (next == null) {
                if (this.nextEntries.hasNext()) {
                    PermissionEntry pe = this.nextEntries.next();
                    if (!this.predicate.apply(pe)) continue;
                    next = pe;
                    continue;
                }
                if (this.path == null) break;
                this.nextEntries = PermissionEntryProviderImpl.this.getEntries(this.path).iterator();
                this.path = PermissionUtil.getParentPathOrNull(this.path);
            }
            return next;
        }
    }
}

