/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.security.Principal;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.security.authorization.permission.AllPermissions;
import org.apache.jackrabbit.oak.security.authorization.permission.CompiledPermissionImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.CompiledPermissions;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;

public class PermissionProviderImpl
implements PermissionProvider,
AccessControlConstants,
PermissionConstants,
AggregatedPermissionProvider {
    private final Root root;
    private final String workspaceName;
    private final Context ctx;
    private final CompiledPermissions compiledPermissions;
    private Root immutableRoot;

    public PermissionProviderImpl(@Nonnull Root root, @Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull RestrictionProvider restrictionProvider, @Nonnull ConfigurationParameters options, @Nonnull Context ctx) {
        this.root = root;
        this.workspaceName = workspaceName;
        this.ctx = ctx;
        this.immutableRoot = RootFactory.createReadOnlyRoot(root);
        this.compiledPermissions = PermissionUtil.isAdminOrSystem(principals, options) ? AllPermissions.getInstance() : CompiledPermissionImpl.create(this.immutableRoot, workspaceName, principals, restrictionProvider, options, ctx);
    }

    @Override
    public void refresh() {
        this.immutableRoot = RootFactory.createReadOnlyRoot(this.root);
        this.compiledPermissions.refresh(this.immutableRoot, this.workspaceName);
    }

    @Override
    @Nonnull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        return this.compiledPermissions.getPrivileges(PermissionUtil.getImmutableTree(tree, this.immutableRoot));
    }

    @Override
    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        return this.compiledPermissions.hasPrivileges(PermissionUtil.getImmutableTree(tree, this.immutableRoot), privilegeNames);
    }

    @Override
    @Nonnull
    public RepositoryPermission getRepositoryPermission() {
        return this.compiledPermissions.getRepositoryPermission();
    }

    @Override
    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreePermission parentPermission) {
        return this.compiledPermissions.getTreePermission(PermissionUtil.getImmutableTree(tree, this.immutableRoot), parentPermission);
    }

    @Override
    public boolean isGranted(@Nonnull Tree tree, @Nullable PropertyState property, long permissions) {
        return this.compiledPermissions.isGranted(PermissionUtil.getImmutableTree(tree, this.immutableRoot), property, permissions);
    }

    @Override
    public boolean isGranted(@Nonnull String oakPath, @Nonnull String jcrActions) {
        TreeLocation location = TreeLocation.create(this.immutableRoot, oakPath);
        boolean isAcContent = this.ctx.definesLocation(location);
        long permissions = Permissions.getPermissions(jcrActions, location, isAcContent);
        return this.isGranted(location, oakPath, permissions);
    }

    @Override
    @Nonnull
    public PrivilegeBits supportedPrivileges(@Nullable Tree tree, @Nullable PrivilegeBits privilegeBits) {
        return privilegeBits != null ? privilegeBits : new PrivilegeBitsProvider(this.immutableRoot).getBits("jcr:all");
    }

    @Override
    public long supportedPermissions(@Nullable Tree tree, @Nullable PropertyState property, long permissions) {
        return permissions;
    }

    @Override
    public long supportedPermissions(@Nonnull TreeLocation location, long permissions) {
        return permissions;
    }

    @Override
    public long supportedPermissions(@Nonnull TreePermission treePermission, @Nullable PropertyState property, long permissions) {
        return permissions;
    }

    @Override
    public boolean isGranted(@Nonnull TreeLocation location, long permissions) {
        return this.isGranted(location, location.getPath(), permissions);
    }

    @Override
    @Nonnull
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreeType type, @Nonnull TreePermission parentPermission) {
        return this.compiledPermissions.getTreePermission(PermissionUtil.getImmutableTree(tree, this.immutableRoot), type, parentPermission);
    }

    private static boolean isVersionStorePath(@Nonnull String oakPath) {
        return oakPath.startsWith("/jcr:system/jcr:versionStorage");
    }

    private boolean isGranted(@Nonnull TreeLocation location, @Nonnull String oakPath, long permissions) {
        Tree tree;
        boolean isGranted = false;
        PropertyState property = location.getProperty();
        Tree tree2 = tree = property == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            isGranted = this.isGranted(tree, property, permissions);
        } else if (!PermissionProviderImpl.isVersionStorePath(location.getPath())) {
            isGranted = this.compiledPermissions.isGranted(oakPath, permissions);
        }
        return isGranted;
    }
}

