/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.base.Strings;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.principal.AdminPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.util.Text;

public final class PermissionUtil
implements PermissionConstants {
    private PermissionUtil() {
    }

    @CheckForNull
    public static String getParentPathOrNull(@Nonnull String path) {
        if (path.length() <= 1) {
            return null;
        }
        int idx = path.lastIndexOf(47);
        if (idx == 0) {
            return "/";
        }
        return path.substring(0, idx);
    }

    @Nonnull
    public static String getEntryName(@Nullable String accessControlledPath) {
        String path = Strings.nullToEmpty((String)accessControlledPath);
        return String.valueOf(path.hashCode());
    }

    public static boolean checkACLPath(@Nonnull NodeBuilder node, @Nonnull String path) {
        PropertyState property = node.getProperty("rep:accessControlledPath");
        return property != null && path.equals(property.getValue(Type.STRING));
    }

    public static boolean checkACLPath(@Nonnull Tree node, @Nonnull String path) {
        PropertyState property = node.getProperty("rep:accessControlledPath");
        return property != null && path.equals(property.getValue(Type.STRING));
    }

    @Nonnull
    public static Tree getPermissionsRoot(@Nonnull Root root, @Nonnull String workspaceName) {
        return root.getTree("/jcr:system/rep:permissionStore/" + workspaceName);
    }

    @Nonnull
    public static Tree getPrincipalRoot(@Nonnull Tree permissionsTree, @Nonnull String principalName) {
        return permissionsTree.getChild(Text.escapeIllegalJcrChars(principalName));
    }

    public static boolean isAdminOrSystem(@Nonnull Set<Principal> principals, @Nonnull ConfigurationParameters config) {
        if (principals.contains(SystemPrincipal.INSTANCE)) {
            return true;
        }
        Set adminNames = config.getConfigValue("administrativePrincipals", Collections.EMPTY_SET);
        for (Principal principal : principals) {
            if (!(principal instanceof AdminPrincipal) && !adminNames.contains(principal.getName())) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public static String getPath(@Nullable Tree parentBefore, @Nullable Tree parentAfter) {
        String path = null;
        if (parentBefore != null) {
            path = parentBefore.getPath();
        } else if (parentAfter != null) {
            path = parentAfter.getPath();
        }
        return path;
    }

    public static Tree getImmutableTree(@Nullable Tree tree, @Nonnull Root immutableRoot) {
        if (tree instanceof ImmutableTree) {
            return tree;
        }
        return tree == null ? null : immutableRoot.getTree(tree.getPath());
    }
}

