/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Preconditions;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.tree.TreeFactory;
import org.apache.jackrabbit.oak.security.user.CacheConstants;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.VisibleValidator;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class CacheValidatorProvider
extends ValidatorProvider
implements CacheConstants {
    private final boolean isSystem;

    CacheValidatorProvider(@Nonnull Set<Principal> principals) {
        this.isSystem = principals.contains(SystemPrincipal.INSTANCE);
    }

    @Override
    @CheckForNull
    protected Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        TypePredicate cachePredicate = new TypePredicate(after, "rep:Cache");
        boolean isValidCommitInfo = CommitMarker.isValidCommitInfo(info);
        return new CacheValidator(TreeFactory.createReadOnlyTree(before), TreeFactory.createReadOnlyTree(after), cachePredicate, isValidCommitInfo);
    }

    static Map<String, Object> asCommitAttributes() {
        return Collections.singletonMap(CommitMarker.KEY, CommitMarker.INSTANCE);
    }

    private static CommitFailedException constraintViolation(int code, @Nonnull String message) {
        return new CommitFailedException("Constraint", code, message);
    }

    private final class CacheValidator
    extends DefaultValidator {
        private final Tree parentBefore;
        private final Tree parentAfter;
        private final TypePredicate cachePredicate;
        private final boolean isValidCommitInfo;
        private final boolean isCache;

        private CacheValidator(@Nonnull Tree parentBefore, Tree parentAfter, TypePredicate cachePredicate, boolean isValidCommitInfo) {
            this.parentBefore = parentBefore;
            this.parentAfter = parentAfter;
            this.cachePredicate = cachePredicate;
            this.isValidCommitInfo = isValidCommitInfo;
            this.isCache = this.isCache(parentAfter);
        }

        @Override
        public void propertyAdded(PropertyState after) throws CommitFailedException {
            if (this.isCache) {
                this.checkValidCommit();
            }
        }

        @Override
        public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
            if (this.isCache) {
                this.checkValidCommit();
            }
        }

        @Override
        public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
            Tree beforeTree = this.parentBefore == null ? null : this.parentBefore.getChild(name);
            Tree afterTree = this.parentAfter.getChild(name);
            if (this.isCache || this.isCache(beforeTree) || this.isCache(afterTree)) {
                this.checkValidCommit();
            }
            return new VisibleValidator(new CacheValidator(beforeTree, afterTree, this.cachePredicate, this.isValidCommitInfo), true, true);
        }

        @Override
        public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
            Tree tree = (Tree)Preconditions.checkNotNull((Object)this.parentAfter.getChild(name));
            if (this.isCache || this.isCache(tree)) {
                this.checkValidCommit();
            }
            return new VisibleValidator(new CacheValidator(null, tree, this.cachePredicate, this.isValidCommitInfo), true, true);
        }

        private boolean isCache(@CheckForNull Tree tree) {
            return tree != null && ("rep:cache".equals(tree.getName()) || this.cachePredicate.apply(tree));
        }

        private void checkValidCommit() throws CommitFailedException {
            if (!CacheValidatorProvider.this.isSystem || !this.isValidCommitInfo) {
                throw CacheValidatorProvider.constraintViolation(34, "Attempt to create or change the system maintained cache.");
            }
        }
    }

    private static final class CommitMarker {
        private static final String KEY = CommitMarker.class.getName();
        private static final CommitMarker INSTANCE = new CommitMarker();

        private static boolean isValidCommitInfo(@Nonnull CommitInfo commitInfo) {
            return INSTANCE == commitInfo.getInfo().get(KEY);
        }

        private CommitMarker() {
        }
    }
}

