/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.nodetype.NodeTypeIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexProvider;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.query.CompositeQueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.NodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserInitializer
implements WorkspaceInitializer,
UserConstants {
    private static final Logger log = LoggerFactory.getLogger(UserInitializer.class);
    private final SecurityProvider securityProvider;

    UserInitializer(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    @Override
    public void initialize(NodeBuilder builder, String workspaceName) {
        NodeState base = ModifiedNodeState.squeeze(builder.getNodeState());
        MemoryNodeStore store = new MemoryNodeStore(base);
        Root root = RootFactory.createSystemRoot(store, EmptyHook.INSTANCE, workspaceName, this.securityProvider, new QueryEngineSettings(), new CompositeQueryIndexProvider(new PropertyIndexProvider(), new NodeTypeIndexProvider()));
        UserConfiguration userConfiguration = this.securityProvider.getConfiguration(UserConfiguration.class);
        UserManager userManager = userConfiguration.getUserManager(root, NamePathMapper.DEFAULT);
        String errorMsg = "Failed to initialize user content.";
        try {
            String anonymousId;
            ConfigurationParameters params;
            String adminId;
            NodeUtil rootTree = (NodeUtil)Preconditions.checkNotNull((Object)new NodeUtil(root.getTree("/")));
            NodeUtil index = rootTree.getOrAddChild("oak:index", "nt:unstructured");
            if (!index.hasChild("authorizableId")) {
                NodeUtil authorizableId = IndexUtils.createIndexDefinition(index, "authorizableId", true, new String[]{"rep:authorizableId"}, new String[]{"rep:Authorizable"});
                authorizableId.setString("info", "Oak index used by the user management to enforce uniqueness of rep:authorizableId property values.");
            }
            if (!index.hasChild("principalName")) {
                NodeUtil principalName = IndexUtils.createIndexDefinition(index, "principalName", true, new String[]{"rep:principalName"}, new String[]{"rep:Authorizable"});
                principalName.setString("info", "Oak index used by the user management to enforce uniqueness of rep:principalName property values, and to quickly search a principal by name if it was constructed manually.");
            }
            if (userManager.getAuthorizable(adminId = (params = userConfiguration.getParameters()).getConfigValue("adminId", "admin")) == null) {
                boolean omitPw = params.getConfigValue("omitAdminPw", false);
                userManager.createUser(adminId, omitPw ? null : adminId);
            }
            if ((anonymousId = Strings.emptyToNull((String)params.getConfigValue("anonymousId", "anonymous", String.class))) != null && userManager.getAuthorizable(anonymousId) == null) {
                userManager.createUser(anonymousId, null);
            }
            if (root.hasPendingChanges()) {
                root.commit();
            }
        }
        catch (RepositoryException e) {
            log.error(errorMsg, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (CommitFailedException e) {
            log.error(errorMsg, (Throwable)e);
            throw new RuntimeException(e);
        }
        NodeState target = store.getRoot();
        target.compareAgainstBaseState(base, new ApplyDiff(builder));
    }
}

