/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.token;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;

public final class CompositeTokenProvider
implements TokenProvider {
    private final List<TokenProvider> providers;
    private static final TokenProvider NULL_PROVIDER = new TokenProvider(){

        @Override
        public boolean doCreateToken(@Nonnull Credentials credentials) {
            return false;
        }

        @Override
        public TokenInfo createToken(@Nonnull Credentials credentials) {
            return null;
        }

        @Override
        public TokenInfo createToken(@Nonnull String userId, @Nonnull Map<String, ?> attributes) {
            return null;
        }

        @Override
        public TokenInfo getTokenInfo(@Nonnull String token) {
            return null;
        }
    };

    private CompositeTokenProvider(@Nonnull List<? extends TokenProvider> providers) {
        this.providers = ImmutableList.copyOf(providers);
    }

    @Nonnull
    public static TokenProvider newInstance(TokenProvider ... providers) {
        return CompositeTokenProvider.newInstance(Arrays.asList(providers));
    }

    @Nonnull
    public static TokenProvider newInstance(@Nonnull List<? extends TokenProvider> providers) {
        switch (providers.size()) {
            case 0: {
                return NULL_PROVIDER;
            }
            case 1: {
                return providers.iterator().next();
            }
        }
        return new CompositeTokenProvider(providers);
    }

    @Override
    public boolean doCreateToken(@Nonnull Credentials credentials) {
        for (TokenProvider tp : this.providers) {
            if (!tp.doCreateToken(credentials)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TokenInfo createToken(@Nonnull Credentials credentials) {
        for (TokenProvider tp : this.providers) {
            TokenInfo info = tp.createToken(credentials);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Override
    public TokenInfo createToken(@Nonnull String userId, @Nonnull Map<String, ?> attributes) {
        for (TokenProvider tp : this.providers) {
            TokenInfo info = tp.createToken(userId, attributes);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Override
    public TokenInfo getTokenInfo(@Nonnull String token) {
        for (TokenProvider tp : this.providers) {
            TokenInfo info = tp.getTokenInfo(token);
            if (info == null) continue;
            return info;
        }
        return null;
    }
}

