/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.io.Closeable;
import java.util.Iterator;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.blob.BlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.plugins.blob.ReferenceCollector;
import org.apache.jackrabbit.oak.plugins.blob.ReferencedBlob;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentBlobReferenceRetriever
implements BlobReferenceRetriever {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DocumentNodeStore nodeStore;

    public DocumentBlobReferenceRetriever(DocumentNodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectReferences(ReferenceCollector collector) {
        int referencesFound = 0;
        Iterator<ReferencedBlob> blobIterator = this.nodeStore.getReferencedBlobsIterator();
        try {
            while (blobIterator.hasNext()) {
                ReferencedBlob refBlob = blobIterator.next();
                Blob blob = refBlob.getBlob();
                ++referencesFound;
                if (blob instanceof BlobStoreBlob) {
                    collector.addReference(((BlobStoreBlob)blob).getBlobId(), refBlob.getId());
                    continue;
                }
                collector.addReference(blob.toString(), refBlob.getId());
            }
        }
        finally {
            if (blobIterator instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Object)blobIterator));
            }
        }
        this.log.debug("Total blob references found (including chunk resolution) [{}]", (Object)referencesFound);
    }
}

