/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeContext;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.plugins.version.VersionConstants;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

public final class TreeTypeProvider {
    private final TreeContext ctx;

    public TreeTypeProvider(@Nonnull TreeContext authorizationContext) {
        this.ctx = authorizationContext;
    }

    public TreeType getType(@Nonnull Tree tree) {
        TreeType type;
        if (tree.isRoot()) {
            return TreeType.DEFAULT;
        }
        if (tree instanceof ImmutableTree) {
            type = ((ImmutableTree)tree).getType();
            if (type == null) {
                type = this.internalGetType(tree);
                ((ImmutableTree)tree).setType(type);
            }
        } else {
            type = this.internalGetType(tree);
        }
        return type;
    }

    public TreeType getType(@Nonnull Tree tree, @Nonnull TreeType parentType) {
        TreeType type;
        if (tree.isRoot()) {
            return TreeType.DEFAULT;
        }
        if (tree instanceof ImmutableTree) {
            type = ((ImmutableTree)tree).getType();
            if (type == null) {
                type = this.internalGetType(tree, parentType);
                ((ImmutableTree)tree).setType(type);
            }
        } else {
            type = this.internalGetType(tree, parentType);
        }
        return type;
    }

    private TreeType internalGetType(@Nonnull Tree tree) {
        Tree t = tree;
        while (!t.isRoot()) {
            TreeType type = this.internalGetType(t.getName(), t);
            if (TreeType.DEFAULT != type) {
                return type;
            }
            t = t.getParent();
        }
        return TreeType.DEFAULT;
    }

    private TreeType internalGetType(@Nonnull Tree tree, @Nonnull TreeType parentType) {
        TreeType type;
        switch (parentType) {
            case HIDDEN: {
                type = TreeType.HIDDEN;
                break;
            }
            case VERSION: {
                type = TreeType.VERSION;
                break;
            }
            case INTERNAL: {
                type = TreeType.INTERNAL;
                break;
            }
            case ACCESS_CONTROL: {
                type = TreeType.ACCESS_CONTROL;
                break;
            }
            default: {
                type = this.internalGetType(tree.getName(), tree);
            }
        }
        return type;
    }

    private TreeType internalGetType(@Nonnull String name, @Nonnull Tree tree) {
        TreeType type = NodeStateUtils.isHidden(name) ? TreeType.HIDDEN : (VersionConstants.VERSION_STORE_ROOT_NAMES.contains(name) ? ("jcr:system".equals(tree.getParent().getName()) ? TreeType.VERSION : TreeType.DEFAULT) : (this.ctx.definesInternal(tree) ? TreeType.INTERNAL : (this.ctx.definesContextRoot(tree) ? TreeType.ACCESS_CONTROL : TreeType.DEFAULT)));
        return type;
    }
}

