/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.util.TreeUtil;

final class PrivilegeContext
implements Context,
PrivilegeConstants {
    private static final Context INSTANCE = new PrivilegeContext();

    private PrivilegeContext() {
    }

    static Context getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean definesProperty(@Nonnull Tree parent, @Nonnull PropertyState property) {
        return this.definesTree(parent) && PRIVILEGE_PROPERTY_NAMES.contains(property.getName());
    }

    @Override
    public boolean definesContextRoot(@Nonnull Tree tree) {
        return "rep:privileges".equals(tree.getName());
    }

    @Override
    public boolean definesTree(@Nonnull Tree tree) {
        return PRIVILEGE_NODETYPE_NAMES.contains(TreeUtil.getPrimaryTypeName(tree));
    }

    @Override
    public boolean definesLocation(@Nonnull TreeLocation location) {
        return location.getPath().startsWith("/jcr:system/rep:privileges");
    }

    @Override
    public boolean definesInternal(@Nonnull Tree tree) {
        return false;
    }
}

