/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;

public interface Filter {
    public Collection<PropertyRestriction> getPropertyRestrictions();

    @Deprecated
    public Collection<String> getFulltextConditions();

    public FullTextExpression getFullTextConstraint();

    public QueryEngineSettings getQueryEngineSettings();

    public boolean isAccessible(String var1);

    public boolean containsNativeConstraint();

    public PropertyRestriction getPropertyRestriction(String var1);

    public List<PropertyRestriction> getPropertyRestrictions(String var1);

    public PathRestriction getPathRestriction();

    public String getPath();

    public String getPathPlan();

    @Nullable
    public String getNodeType();

    public boolean matchesAllTypes();

    @Nonnull
    public Set<String> getSupertypes();

    @Nonnull
    public Set<String> getPrimaryTypes();

    @Nonnull
    public Set<String> getMixinTypes();

    @Nullable
    public String getQueryStatement();

    public boolean isAlwaysFalse();

    public static enum PathRestriction {
        NO_RESTRICTION("*"),
        PARENT("/.."),
        EXACT(""),
        DIRECT_CHILDREN("/*"),
        ALL_CHILDREN("//*");

        private final String name;

        private PathRestriction(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class PropertyRestriction {
        public String propertyName;
        public PropertyValue first;
        public boolean firstIncluding;
        public PropertyValue last;
        public boolean lastIncluding;
        public boolean isLike;
        public List<PropertyValue> list;
        public int propertyType = 0;

        public boolean isNullRestriction() {
            return this.first == null && this.last == null && this.list == null && this.lastIncluding && this.firstIncluding;
        }

        public boolean isNotNullRestriction() {
            return this.first == null && this.last == null && this.list == null && !this.lastIncluding && !this.firstIncluding;
        }

        public String toString() {
            return (this.toStringFromTo() + " " + this.toStringList()).trim();
        }

        private String toStringList() {
            if (this.list == null) {
                return "";
            }
            StringBuilder buff = new StringBuilder("in(");
            int i = 0;
            for (PropertyValue p : this.list) {
                if (i++ > 0) {
                    buff.append(", ");
                }
                buff.append(p.toString());
            }
            buff.append(')');
            return buff.toString();
        }

        private String toStringFromTo() {
            String fi;
            String l;
            if (this.isNullRestriction()) {
                return "is null";
            }
            if (this.isNotNullRestriction()) {
                return "is not null";
            }
            String f = this.first == null ? "" : this.first.toString();
            String string = l = this.last == null ? "" : this.last.toString();
            if (f.equals(l)) {
                return f;
            }
            String string2 = this.first == null ? "" : (fi = this.firstIncluding ? "[" : "(");
            String li = this.last == null ? "" : (this.lastIncluding ? "]" : ")");
            return fi + f + ".." + l + li;
        }

        public int sortOrder() {
            if (this.first == null && this.last == null) {
                if (this.list == null) {
                    return 0;
                }
                return 5;
            }
            if (this.first == this.last) {
                return 10;
            }
            return 5;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
            result = 31 * result + (this.firstIncluding ? 1231 : 1237);
            result = 31 * result + (this.isLike ? 1231 : 1237);
            result = 31 * result + (this.last == null ? 0 : this.last.hashCode());
            result = 31 * result + (this.lastIncluding ? 1231 : 1237);
            result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
            result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
            result = 31 * result + this.propertyType;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyRestriction other = (PropertyRestriction)obj;
            if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
                return false;
            }
            if (this.firstIncluding != other.firstIncluding) {
                return false;
            }
            if (this.isLike != other.isLike) {
                return false;
            }
            if (this.last == null ? other.last != null : !this.last.equals(other.last)) {
                return false;
            }
            if (this.lastIncluding != other.lastIncluding) {
                return false;
            }
            if (this.list == null ? other.list != null : !this.list.equals(other.list)) {
                return false;
            }
            if (this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName)) {
                return false;
            }
            return this.propertyType == other.propertyType;
        }
    }
}

