/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.OpenAuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.OpenAuthorizationConfiguration;

public class OpenSecurityProvider
implements SecurityProvider {
    @Override
    @Nonnull
    public ConfigurationParameters getParameters(@Nullable String name) {
        return ConfigurationParameters.EMPTY;
    }

    @Override
    @Nonnull
    public Iterable<? extends SecurityConfiguration> getConfigurations() {
        return ImmutableList.of((Object)new OpenAuthenticationConfiguration(), (Object)new OpenAuthorizationConfiguration());
    }

    @Override
    @Nonnull
    public <T> T getConfiguration(@Nonnull Class<T> configClass) {
        if (AuthenticationConfiguration.class == configClass) {
            return (T)new OpenAuthenticationConfiguration();
        }
        if (AuthorizationConfiguration.class == configClass) {
            return (T)new OpenAuthorizationConfiguration();
        }
        throw new IllegalArgumentException("Unsupported security configuration class " + configClass);
    }
}

