/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.jcr.NoSuchWorkspaceException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.PreAuthenticatedLogin;
import org.apache.jackrabbit.oak.spi.security.authentication.SystemSubject;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.CredentialsCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.PrincipalProviderCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.RepositoryCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.UserManagerCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.WhiteboardCallback;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoginModule.class);
    public static final String SHARED_KEY_CREDENTIALS = "org.apache.jackrabbit.credentials";
    public static final String SHARED_KEY_LOGIN_NAME = "javax.security.auth.login.name";
    public static final String SHARED_KEY_ATTRIBUTES = "javax.security.auth.login.attributes";
    public static final String SHARED_KEY_PRE_AUTH_LOGIN = PreAuthenticatedLogin.class.getName();
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected ConfigurationParameters options;
    private SecurityProvider securityProvider;
    private Whiteboard whiteboard;
    private ContentSession systemSession;
    private Root root;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options == null ? ConfigurationParameters.EMPTY : ConfigurationParameters.of(options);
    }

    @Override
    public boolean logout() throws LoginException {
        boolean success = false;
        if (!this.subject.getPrincipals().isEmpty() && !this.subject.getPublicCredentials(Credentials.class).isEmpty()) {
            if (!this.subject.isReadOnly()) {
                this.subject.getPrincipals().clear();
                this.subject.getPublicCredentials().clear();
            }
            success = true;
        }
        return success;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clearState();
        return true;
    }

    protected void clearState() {
        this.securityProvider = null;
        this.root = null;
        if (this.systemSession != null) {
            try {
                this.systemSession.close();
            }
            catch (IOException e) {
                log.debug(e.getMessage());
            }
        }
    }

    @Nonnull
    protected abstract Set<Class> getSupportedCredentials();

    @CheckForNull
    protected Credentials getCredentials() {
        Credentials creds;
        Set<Class> supported = this.getSupportedCredentials();
        if (this.callbackHandler != null) {
            log.debug("Login: retrieving Credentials using callback.");
            try {
                CredentialsCallback callback = new CredentialsCallback();
                this.callbackHandler.handle(new Callback[]{callback});
                Credentials creds2 = callback.getCredentials();
                if (creds2 != null && supported.contains(creds2.getClass())) {
                    log.debug("Login: Credentials '{}' obtained from callback", (Object)creds2);
                    return creds2;
                }
                log.debug("Login: No supported credentials obtained from callback; trying shared state.");
            }
            catch (UnsupportedCallbackException e) {
                log.warn(e.getMessage());
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        if ((creds = this.getSharedCredentials()) != null && supported.contains(creds.getClass())) {
            log.debug("Login: Credentials obtained from shared state.");
            return creds;
        }
        log.debug("Login: No supported credentials found in shared state; looking for credentials in subject.");
        for (Class clz : this.getSupportedCredentials()) {
            Set cds = this.subject.getPublicCredentials(clz);
            if (cds.isEmpty()) continue;
            log.debug("Login: Credentials found in subject.");
            return (Credentials)cds.iterator().next();
        }
        log.debug("No credentials found.");
        return null;
    }

    @CheckForNull
    protected Credentials getSharedCredentials() {
        Credentials shared = null;
        if (this.sharedState.containsKey(SHARED_KEY_CREDENTIALS)) {
            Object sc = this.sharedState.get(SHARED_KEY_CREDENTIALS);
            if (sc instanceof Credentials) {
                shared = (Credentials)sc;
            } else {
                log.debug("Login: Invalid value for share state entry org.apache.jackrabbit.credentials. Credentials expected.");
            }
        }
        return shared;
    }

    @CheckForNull
    protected String getSharedLoginName() {
        if (this.sharedState.containsKey(SHARED_KEY_LOGIN_NAME)) {
            return this.sharedState.get(SHARED_KEY_LOGIN_NAME).toString();
        }
        return null;
    }

    @CheckForNull
    protected PreAuthenticatedLogin getSharedPreAuthLogin() {
        Object login = this.sharedState.get(SHARED_KEY_PRE_AUTH_LOGIN);
        if (login instanceof PreAuthenticatedLogin) {
            return (PreAuthenticatedLogin)login;
        }
        return null;
    }

    @CheckForNull
    protected SecurityProvider getSecurityProvider() {
        if (this.securityProvider == null && this.callbackHandler != null) {
            RepositoryCallback rcb = new RepositoryCallback();
            try {
                this.callbackHandler.handle(new Callback[]{rcb});
                this.securityProvider = rcb.getSecurityProvider();
            }
            catch (Exception e) {
                log.debug("Unable to retrieve the SecurityProvider via callback", (Throwable)e);
            }
        }
        return this.securityProvider;
    }

    @CheckForNull
    protected Whiteboard getWhiteboard() {
        if (this.whiteboard == null && this.callbackHandler != null) {
            WhiteboardCallback cb = new WhiteboardCallback();
            try {
                this.callbackHandler.handle(new Callback[]{cb});
                this.whiteboard = cb.getWhiteboard();
            }
            catch (Exception e) {
                log.debug("Unable to retrieve the Whiteboard via callback", (Throwable)e);
            }
        }
        return this.whiteboard;
    }

    @CheckForNull
    protected Root getRoot() {
        if (this.root == null && this.callbackHandler != null) {
            try {
                final RepositoryCallback rcb = new RepositoryCallback();
                this.callbackHandler.handle(new Callback[]{rcb});
                final ContentRepository repository = rcb.getContentRepository();
                this.systemSession = Subject.doAs(SystemSubject.INSTANCE, new PrivilegedExceptionAction<ContentSession>(){

                    @Override
                    public ContentSession run() throws LoginException, NoSuchWorkspaceException {
                        return repository.login(null, rcb.getWorkspaceName());
                    }
                });
                this.root = this.systemSession.getLatestRoot();
            }
            catch (UnsupportedCallbackException e) {
                log.debug(e.getMessage());
            }
            catch (IOException e) {
                log.debug(e.getMessage());
            }
            catch (PrivilegedActionException e) {
                log.debug(e.getMessage());
            }
        }
        return this.root;
    }

    @CheckForNull
    protected UserManager getUserManager() {
        UserManager userManager = null;
        SecurityProvider sp = this.getSecurityProvider();
        Root r = this.getRoot();
        if (r != null && sp != null) {
            UserConfiguration uc = this.securityProvider.getConfiguration(UserConfiguration.class);
            userManager = uc.getUserManager(r, NamePathMapper.DEFAULT);
        }
        if (userManager == null && this.callbackHandler != null) {
            try {
                UserManagerCallback userCallBack = new UserManagerCallback();
                this.callbackHandler.handle(new Callback[]{userCallBack});
                userManager = userCallBack.getUserManager();
            }
            catch (IOException e) {
                log.debug(e.getMessage());
            }
            catch (UnsupportedCallbackException e) {
                log.debug(e.getMessage());
            }
        }
        return userManager;
    }

    @CheckForNull
    protected PrincipalProvider getPrincipalProvider() {
        PrincipalProvider principalProvider = null;
        SecurityProvider sp = this.getSecurityProvider();
        Root r = this.getRoot();
        if (r != null && sp != null) {
            PrincipalConfiguration pc = sp.getConfiguration(PrincipalConfiguration.class);
            principalProvider = pc.getPrincipalProvider(r, NamePathMapper.DEFAULT);
        }
        if (principalProvider == null && this.callbackHandler != null) {
            try {
                PrincipalProviderCallback principalCallBack = new PrincipalProviderCallback();
                this.callbackHandler.handle(new Callback[]{principalCallBack});
                principalProvider = principalCallBack.getPrincipalProvider();
            }
            catch (IOException e) {
                log.debug(e.getMessage());
            }
            catch (UnsupportedCallbackException e) {
                log.debug(e.getMessage());
            }
        }
        return principalProvider;
    }

    @Nonnull
    protected Set<? extends Principal> getPrincipals(@Nonnull String userId) {
        PrincipalProvider principalProvider = this.getPrincipalProvider();
        if (principalProvider == null) {
            log.debug("Cannot retrieve principals. No principal provider configured.");
            return Collections.emptySet();
        }
        return principalProvider.getPrincipals(userId);
    }

    protected static void setAuthInfo(@Nonnull AuthInfo authInfo, @Nonnull Subject subject) {
        Set<AuthInfo> ais = subject.getPublicCredentials(AuthInfo.class);
        if (!ais.isEmpty()) {
            subject.getPublicCredentials().removeAll(ais);
        }
        subject.getPublicCredentials().add(authInfo);
    }
}

