/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.util;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public final class PerfLogger {
    private final Logger delegate;

    public PerfLogger(Logger delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.delegate = delegate;
    }

    public final long start() {
        if (!this.delegate.isDebugEnabled()) {
            return -1L;
        }
        return this.start(null);
    }

    public final long start(String traceMsgOrNull) {
        if (!this.delegate.isDebugEnabled()) {
            return -1L;
        }
        if (traceMsgOrNull != null && this.delegate.isTraceEnabled()) {
            this.delegate.trace(traceMsgOrNull);
        }
        return System.nanoTime();
    }

    public final void end(long start, long logAtDebugIfSlowerThanMs, String logMessagePrefix, Object arg1) {
        if (start < 0L) {
            return;
        }
        this.end(start, logAtDebugIfSlowerThanMs, logMessagePrefix, new Object[]{arg1});
    }

    public final void end(long start, long logAtDebugIfSlowerThanMs, String logMessagePrefix, Object arg1, Object arg2) {
        if (start < 0L) {
            return;
        }
        this.end(start, logAtDebugIfSlowerThanMs, logMessagePrefix, new Object[]{arg1, arg2});
    }

    public void end(long start, long logAtDebugIfSlowerThanMs, String logMessagePrefix, Object ... arguments) {
        if (start < 0L) {
            return;
        }
        long diff = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        if (this.delegate.isTraceEnabled()) {
            this.delegate.trace(logMessagePrefix + " [took " + diff + "ms]", arguments);
        } else if (logAtDebugIfSlowerThanMs < 0L || diff > logAtDebugIfSlowerThanMs) {
            this.delegate.debug(logMessagePrefix + " [took " + diff + "ms]", arguments);
        }
    }

    public final boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public final boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }
}

