/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.migration;

import com.google.common.base.Joiner;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepthFirstNodeIterator
extends AbstractIterator<ChildNodeEntry> {
    private static final Logger log = LoggerFactory.getLogger(DepthFirstNodeIterator.class);
    private final Deque<Iterator<? extends ChildNodeEntry>> itQueue;
    private final Deque<String> nameQueue;
    private final NodeState root;

    public DepthFirstNodeIterator(NodeState root) {
        this.root = root;
        this.itQueue = new ArrayDeque<Iterator<? extends ChildNodeEntry>>();
        this.nameQueue = new ArrayDeque<String>();
        this.reset();
    }

    private DepthFirstNodeIterator(NodeState root, Deque<Iterator<? extends ChildNodeEntry>> itQueue, Deque<String> nameQueue) {
        this.root = root;
        this.itQueue = itQueue;
        this.nameQueue = nameQueue;
    }

    public void reset() {
        this.itQueue.clear();
        this.nameQueue.clear();
        this.itQueue.add(this.root.getChildNodeEntries().iterator());
    }

    protected ChildNodeEntry computeNext() {
        if (this.itQueue.isEmpty()) {
            return (ChildNodeEntry)this.endOfData();
        }
        if (this.itQueue.peekLast().hasNext()) {
            ChildNodeEntry next = this.itQueue.peekLast().next();
            this.itQueue.add(next.getNodeState().getChildNodeEntries().iterator());
            this.nameQueue.add(next.getName());
            return next;
        }
        this.itQueue.pollLast();
        if (!this.nameQueue.isEmpty()) {
            this.nameQueue.pollLast();
        }
        return this.computeNext();
    }

    public NodeBuilder getBuilder(NodeBuilder rootBuilder) {
        NodeBuilder builder = rootBuilder;
        for (String name : this.nameQueue) {
            builder = builder.getChildNode(name);
        }
        return builder;
    }

    public String getPath() {
        StringBuilder path = new StringBuilder("/");
        return Joiner.on((char)'/').appendTo(path, this.nameQueue).toString();
    }

    public DepthFirstNodeIterator switchRoot(NodeState newRoot) {
        ArrayDeque<Iterator<? extends ChildNodeEntry>> newQueue = new ArrayDeque<Iterator<? extends ChildNodeEntry>>();
        NodeState current = newRoot;
        for (String name : this.nameQueue) {
            boolean found = false;
            Iterator<? extends ChildNodeEntry> it = current.getChildNodeEntries().iterator();
            newQueue.add(it);
            while (it.hasNext()) {
                ChildNodeEntry e = it.next();
                if (!name.equals(e.getName())) continue;
                current = e.getNodeState();
                found = true;
                break;
            }
            if (found) continue;
            log.warn("Can't found {} in the new root. Switching to /", (Object)this.getPath());
            return new DepthFirstNodeIterator(newRoot);
        }
        newQueue.add(current.getChildNodeEntries().iterator());
        return new DepthFirstNodeIterator(newRoot, newQueue, this.nameQueue);
    }
}

