/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property.strategy;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.counter.ApproximateCounter;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexEntry;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.plugins.memory.MultiStringPropertyState;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueEntryStoreStrategy
implements IndexStoreStrategy {
    static final Logger LOG = LoggerFactory.getLogger(UniqueEntryStoreStrategy.class);
    private static final Consumer<NodeBuilder> NOOP = nb -> {};
    private final String indexName;
    private final Consumer<NodeBuilder> insertCallback;

    public UniqueEntryStoreStrategy() {
        this(":index");
    }

    public UniqueEntryStoreStrategy(String indexName) {
        this(indexName, NOOP);
    }

    public UniqueEntryStoreStrategy(String indexName, @NotNull Consumer<NodeBuilder> insertCallback) {
        this.indexName = indexName;
        this.insertCallback = insertCallback;
    }

    @Override
    public void update(Supplier<NodeBuilder> index, String path, @Nullable String indexName, @Nullable NodeBuilder indexMeta, Set<String> beforeKeys, Set<String> afterKeys) {
        for (String key : beforeKeys) {
            UniqueEntryStoreStrategy.remove((NodeBuilder)index.get(), key, path);
        }
        for (String key : afterKeys) {
            this.insert((NodeBuilder)index.get(), key, path);
        }
    }

    private static void remove(NodeBuilder index, String key, String value) {
        ApproximateCounter.adjustCountSync(index, -1L);
        NodeBuilder builder = index.getChildNode(key);
        if (builder.exists()) {
            PropertyState s = builder.getProperty("entry");
            if (s.count() == 1) {
                builder.remove();
            } else {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < s.count(); ++i) {
                    String r = s.getValue(Type.STRING, i);
                    if (r.equals(value)) continue;
                    list.add(r);
                }
                PropertyState s2 = MultiStringPropertyState.stringProperty("entry", list);
                builder.setProperty(s2);
            }
        }
    }

    private void insert(NodeBuilder index, String key, String value) {
        ApproximateCounter.adjustCountSync(index, 1L);
        NodeBuilder k = index.child(key);
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        if (k.hasProperty("entry")) {
            PropertyState s = k.getProperty("entry");
            for (int i = 0; i < s.count(); ++i) {
                String r = s.getValue(Type.STRING, i);
                if (list.contains(r)) continue;
                list.add(r);
            }
        }
        PropertyState s2 = MultiStringPropertyState.stringProperty("entry", list);
        k.setProperty(s2);
        this.insertCallback.accept(k);
    }

    @Override
    public Iterable<String> query(Filter filter, String indexName, NodeState indexMeta, Iterable<String> values) {
        return this.query0(filter, indexName, indexMeta, values, new HitProducer<String>(){

            @Override
            public String produce(NodeState indexHit, String pathName) {
                PropertyState s = indexHit.getProperty("entry");
                if (s.count() <= 1) {
                    return s.getValue(Type.STRING, 0);
                }
                StringBuilder buff = new StringBuilder();
                for (int i = 0; i < s.count(); ++i) {
                    if (i > 0) {
                        buff.append(", ");
                    }
                    buff.append(s.getValue(Type.STRING, i));
                }
                return buff.toString();
            }
        });
    }

    public Iterable<IndexEntry> queryEntries(Filter filter, String indexName, NodeState indexMeta, Iterable<String> values) {
        return this.query0(filter, indexName, indexMeta, values, new HitProducer<IndexEntry>(){

            @Override
            public IndexEntry produce(NodeState indexHit, String pathName) {
                PropertyState s = indexHit.getProperty("entry");
                return new IndexEntry(s.getValue(Type.STRING, 0), pathName);
            }
        });
    }

    private <T> Iterable<T> query0(Filter filter, String indexName, NodeState indexMeta, final Iterable<String> values, final HitProducer<T> prod) {
        final NodeState index = indexMeta.getChildNode(this.getIndexNodeName());
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                if (values == null) {
                    return new Iterator<T>(){
                        Iterator<? extends ChildNodeEntry> it;
                        {
                            this.it = index.getChildNodeEntries().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public T next() {
                            ChildNodeEntry indexEntry = this.it.next();
                            return prod.produce(indexEntry.getNodeState(), indexEntry.getName());
                        }

                        @Override
                        public void remove() {
                            this.it.remove();
                        }
                    };
                }
                ArrayList list = new ArrayList();
                for (String p : values) {
                    NodeState key = index.getChildNode(p);
                    if (!key.exists()) continue;
                    list.add(prod.produce(key, p));
                }
                return list.iterator();
            }
        };
    }

    @Override
    public boolean exists(Supplier<NodeBuilder> index, String key) {
        return ((NodeBuilder)index.get()).hasChildNode(key);
    }

    @Override
    public long count(NodeState root, NodeState indexMeta, Set<String> values, int max) {
        NodeState index = indexMeta.getChildNode(this.getIndexNodeName());
        long count = 0L;
        if (values == null) {
            long approxCount;
            PropertyState ec = indexMeta.getProperty("entryCount");
            if (ec != null && (count = ec.getValue(Type.LONG).longValue()) >= 0L) {
                return count;
            }
            if (count == 0L && (approxCount = ApproximateCounter.getCountSync(index)) != -1L) {
                return approxCount;
            }
            count = 1L + index.getChildNodeCount(max);
            count *= 10L;
        } else {
            NodeState k;
            count = values.size() == 1 ? ((k = index.getChildNode(values.iterator().next())).exists() ? (long)k.getProperty("entry").count() : 0L) : (long)values.size();
        }
        return count;
    }

    @Override
    public long count(Filter filter, NodeState root, NodeState indexMeta, Set<String> values, int max) {
        return this.count(root, indexMeta, values, max);
    }

    @Override
    public String getIndexNodeName() {
        return this.indexName;
    }

    private static interface HitProducer<T> {
        public T produce(NodeState var1, String var2);
    }
}

