/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinitionImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrincipalRestrictionProvider
implements RestrictionProvider,
AccessControlConstants {
    private final RestrictionProvider base;

    public PrincipalRestrictionProvider(RestrictionProvider base) {
        this.base = base;
    }

    @Override
    @NotNull
    public Set<RestrictionDefinition> getSupportedRestrictions(@Nullable String oakPath) {
        HashSet<RestrictionDefinition> definitions = new HashSet<RestrictionDefinition>(this.base.getSupportedRestrictions(oakPath));
        definitions.add(new RestrictionDefinitionImpl("rep:nodePath", Type.PATH, true));
        return definitions;
    }

    @Override
    @NotNull
    public Restriction createRestriction(@Nullable String oakPath, @NotNull String oakName, @NotNull Value value) throws RepositoryException {
        if ("rep:nodePath".equals(oakName)) {
            PropertyState property = value.getString().isEmpty() ? PropertyStates.createProperty(oakName, (Object)"", Type.STRING) : PropertyStates.createProperty(oakName, value);
            return new RestrictionImpl(property, true);
        }
        return this.base.createRestriction(oakPath, oakName, value);
    }

    @Override
    @NotNull
    public Restriction createRestriction(@Nullable String oakPath, @NotNull String oakName, Value ... values) throws RepositoryException {
        return this.base.createRestriction(oakPath, oakName, values);
    }

    @Override
    @NotNull
    public Set<Restriction> readRestrictions(@Nullable String oakPath, @NotNull Tree aceTree) {
        HashSet<Restriction> restrictions = new HashSet<Restriction>(this.base.readRestrictions(oakPath, aceTree));
        PropertyState property = oakPath == null ? PropertyStates.createProperty("rep:nodePath", (Object)"", Type.STRING) : PropertyStates.createProperty("rep:nodePath", (Object)oakPath, Type.PATH);
        restrictions.add(new RestrictionImpl(property, true));
        return restrictions;
    }

    @Override
    public void writeRestrictions(String oakPath, Tree aceTree, Set<Restriction> restrictions) throws RepositoryException {
        Sets.newHashSet(restrictions).removeIf(r -> "rep:nodePath".equals(r.getDefinition().getName()));
        this.base.writeRestrictions(oakPath, aceTree, restrictions);
    }

    @Override
    public void validateRestrictions(String oakPath, @NotNull Tree aceTree) throws RepositoryException {
        this.base.validateRestrictions(oakPath, aceTree);
    }

    @Override
    @NotNull
    public RestrictionPattern getPattern(@Nullable String oakPath, @NotNull Tree tree) {
        return this.base.getPattern(oakPath, tree);
    }

    @Override
    @NotNull
    public RestrictionPattern getPattern(@Nullable String oakPath, @NotNull Set<Restriction> restrictions) {
        return this.base.getPattern(oakPath, restrictions);
    }
}

