/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.security.Principal;
import java.text.ParseException;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.AuthorizableBaseProvider;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.apache.jackrabbit.oak.security.user.Utils;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableNodeName;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserProvider
extends AuthorizableBaseProvider {
    private static final Logger log = LoggerFactory.getLogger(UserProvider.class);
    private static final String DELIMITER = "/";
    private final int defaultDepth;
    private final String groupPath;
    private final String userPath;

    UserProvider(@NotNull Root root, @NotNull ConfigurationParameters config) {
        super(root, config);
        this.defaultDepth = config.getConfigValue("defaultDepth", 2);
        this.groupPath = config.getConfigValue("groupsPath", "/rep:security/rep:authorizables/rep:groups");
        this.userPath = config.getConfigValue("usersPath", "/rep:security/rep:authorizables/rep:users");
    }

    @NotNull
    Tree createUser(@NotNull String userID, @Nullable String intermediateJcrPath) throws RepositoryException {
        return this.createAuthorizableNode(userID, "rep:User", intermediateJcrPath);
    }

    @NotNull
    Tree createGroup(@NotNull String groupID, @Nullable String intermediateJcrPath) throws RepositoryException {
        return this.createAuthorizableNode(groupID, "rep:Group", intermediateJcrPath);
    }

    @NotNull
    Tree createSystemUser(@NotNull String userID, @Nullable String intermediateJcrPath) throws RepositoryException {
        String relPath;
        String relSysPath = this.config.getConfigValue("systemRelativePath", "system");
        if (intermediateJcrPath == null) {
            relPath = relSysPath;
        } else {
            if (!intermediateJcrPath.startsWith(relSysPath) && !intermediateJcrPath.startsWith(this.userPath + '/' + relSysPath)) {
                throw new ConstraintViolationException("System users must be located in the 'system' subtree of the user root.");
            }
            relPath = intermediateJcrPath;
        }
        return this.createAuthorizableNode(userID, "rep:SystemUser", relPath);
    }

    @Nullable
    Tree getAuthorizable(@NotNull String authorizableId) {
        return this.getByID(authorizableId, AuthorizableType.AUTHORIZABLE);
    }

    @Nullable
    Tree getAuthorizableByPath(@NotNull String authorizableOakPath) {
        return this.getByPath(authorizableOakPath, AuthorizableType.AUTHORIZABLE);
    }

    @Nullable
    Tree getAuthorizableByPrincipal(@NotNull Principal principal) {
        if (principal instanceof TreeBasedPrincipal) {
            return this.root.getTree(((TreeBasedPrincipal)((Object)principal)).getOakPath());
        }
        try {
            StringBuilder stmt = new StringBuilder();
            stmt.append("SELECT * FROM [").append("rep:Authorizable").append(']');
            stmt.append(" WHERE [").append("rep:principalName").append("] = $principalName");
            stmt.append(" /* oak-internal */");
            Result result = this.root.getQueryEngine().executeQuery(stmt.toString(), "JCR-SQL2", 1L, 0L, Collections.singletonMap("principalName", PropertyValues.newString(principal.getName())), QueryEngine.NO_MAPPINGS);
            Iterator<? extends ResultRow> rows = result.getRows().iterator();
            if (rows.hasNext()) {
                String path = rows.next().getPath();
                return this.root.getTree(path);
            }
        }
        catch (ParseException ex) {
            log.error("Failed to retrieve authorizable by principal", (Throwable)ex);
        }
        return null;
    }

    private Tree createAuthorizableNode(@NotNull String authorizableId, @NotNull String ntName, @Nullable String intermediatePath) throws RepositoryException {
        String nodeName = this.getNodeName(authorizableId);
        Tree folder = this.createFolderNodes(nodeName, "rep:Group".equals(ntName), intermediatePath);
        if (folder.hasChild(nodeName)) {
            int i = 1;
            String tmp = nodeName + i;
            while (folder.hasChild(tmp)) {
                tmp = nodeName + ++i;
            }
            nodeName = tmp;
        }
        Tree typeRoot = this.root.getTree("/jcr:system/jcr:nodeTypes");
        String userId = Strings.nullToEmpty((String)this.root.getContentSession().getAuthInfo().getUserID());
        Tree authorizableNode = TreeUtil.addChild(folder, nodeName, ntName, typeRoot, userId);
        authorizableNode.setProperty("rep:authorizableId", authorizableId);
        authorizableNode.setProperty("jcr:uuid", this.getContentID(authorizableId));
        return authorizableNode;
    }

    private Tree createFolderNodes(@NotNull String nodeName, boolean isGroup, @Nullable String intermediatePath) throws RepositoryException {
        Tree colliding;
        String primaryType;
        Tree folder;
        String authRoot = isGroup ? this.groupPath : this.userPath;
        String folderPath = authRoot + this.getFolderPath(nodeName, intermediatePath, authRoot);
        Tree tree = this.root.getTree(folderPath);
        while (!tree.isRoot() && !tree.exists()) {
            tree = tree.getParent();
        }
        if (tree.exists()) {
            folder = tree;
            String relativePath = PathUtils.relativize(tree.getPath(), folderPath);
            if (!relativePath.isEmpty()) {
                folder = Utils.getOrAddTree(folder, relativePath, "rep:AuthorizableFolder");
            }
        } else {
            throw new AccessDeniedException("Missing permission to create intermediate authorizable folders.");
        }
        while (folder.hasChild(nodeName) && "rep:AuthorizableFolder".equals(primaryType = TreeUtil.getPrimaryTypeName(colliding = folder.getChild(nodeName)))) {
            log.debug("Existing folder node collides with user/group to be created. Expanding path by: {}", (Object)colliding.getName());
            folder = colliding;
        }
        return folder;
    }

    @NotNull
    private String getFolderPath(@NotNull String nodeName, @Nullable String intermediatePath, @NotNull String authRoot) throws ConstraintViolationException {
        boolean emptyOrNull = intermediatePath == null || intermediatePath.isEmpty() || authRoot.equals(intermediatePath);
        StringBuilder sb = new StringBuilder();
        if (!emptyOrNull) {
            if (intermediatePath.charAt(0) == '/') {
                if (!intermediatePath.startsWith(authRoot)) {
                    throw new ConstraintViolationException("Attempt to create authorizable at '" + intermediatePath + "' outside of the configured root '" + authRoot + '\'');
                }
                intermediatePath = intermediatePath.substring(authRoot.length() + 1);
            }
            sb.append(DELIMITER).append(intermediatePath);
        } else {
            String hint = Text.unescapeIllegalJcrChars(nodeName);
            int idLength = hint.length();
            StringBuilder segment = new StringBuilder();
            for (int i = 0; i < this.defaultDepth; ++i) {
                if (idLength > i) {
                    segment.append(hint.charAt(i));
                } else {
                    segment.append(hint.charAt(idLength - 1));
                }
                sb.append(DELIMITER).append(Text.escapeIllegalJcrChars(segment.toString()));
            }
        }
        return sb.toString();
    }

    private String getNodeName(@NotNull String authorizableId) {
        AuthorizableNodeName generator = (AuthorizableNodeName)Preconditions.checkNotNull((Object)this.config.getConfigValue("authorizableNodeName", AuthorizableNodeName.DEFAULT, AuthorizableNodeName.class));
        return generator.generateNodeName(authorizableId);
    }
}

