/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.oak;

import java.util.Collections;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;

final class ExtraSlingContent
implements RepositoryInitializer {
    ExtraSlingContent() {
    }

    @Override
    public void initialize(@NotNull NodeBuilder root) {
        NodeBuilder jcrSystem;
        String slingNs = "sling";
        if (root.hasChildNode("jcr:system") && (jcrSystem = root.getChildNode("jcr:system")).hasChildNode("rep:namespaces")) {
            NodeBuilder namespaces = jcrSystem.getChildNode("rep:namespaces");
            slingNs = Namespaces.addCustomMapping(namespaces, "http://sling.apache.org/", slingNs);
            Namespaces.buildIndexNode(namespaces);
        }
        if (root.hasChildNode("oak:index")) {
            NodeBuilder index = root.child("oak:index");
            ExtraSlingContent.property(index, "jcrLanguage", "jcr:language");
            ExtraSlingContent.property(index, "jcrLockOwner", "jcr:lockOwner");
            ExtraSlingContent.property(index, "slingAlias", slingNs + ":alias");
            ExtraSlingContent.property(index, "slingResource", slingNs + ":resource");
            ExtraSlingContent.property(index, "slingResourceType", slingNs + ":resourceType");
            ExtraSlingContent.property(index, "slingVanityPath", slingNs + ":vanityPath");
        }
    }

    private static void property(NodeBuilder index, String indexName, String propertyName) {
        if (!index.hasChildNode(indexName)) {
            IndexUtils.createIndexDefinition(index, indexName, true, false, Collections.singleton(propertyName), null);
        }
    }
}

