/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.EffectiveNodeTypeImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.RootNodeDefinition;
import org.apache.jackrabbit.oak.spi.nodetype.DefinitionProvider;
import org.apache.jackrabbit.oak.spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.oak.spi.nodetype.EffectiveNodeTypeProvider;

public abstract class ReadOnlyNodeTypeManager
implements NodeTypeManager,
EffectiveNodeTypeProvider,
DefinitionProvider {
    @Nonnull
    protected final String getOakName(String jcrName) throws RepositoryException {
        return this.getNamePathMapper().getOakName(jcrName);
    }

    @CheckForNull
    protected abstract Tree getTypes();

    @CheckForNull
    protected ValueFactory getValueFactory() {
        return null;
    }

    @Nonnull
    protected NamePathMapper getNamePathMapper() {
        return NamePathMapper.DEFAULT;
    }

    @Nonnull
    public static ReadOnlyNodeTypeManager getInstance(final Root root, final NamePathMapper namePathMapper) {
        return new ReadOnlyNodeTypeManager(){

            @Override
            protected Tree getTypes() {
                return root.getTree("/jcr:system/jcr:nodeTypes");
            }

            @Override
            @Nonnull
            protected NamePathMapper getNamePathMapper() {
                return namePathMapper;
            }
        };
    }

    public boolean hasNodeType(String name) throws RepositoryException {
        Tree types = this.getTypes();
        return types != null && types.hasChild(this.getOakName(name));
    }

    public NodeType getNodeType(String name) throws RepositoryException {
        return this.internalGetNodeType(this.getOakName(name));
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        ArrayList list = Lists.newArrayList();
        Tree types = this.getTypes();
        if (types != null) {
            NamePathMapper mapper = this.getNamePathMapper();
            for (Tree type : types.getChildren()) {
                list.add(new NodeTypeImpl(type, mapper));
            }
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        ArrayList list = Lists.newArrayList();
        NodeTypeIterator iterator = this.getAllNodeTypes();
        while (iterator.hasNext()) {
            NodeType type = iterator.nextNodeType();
            if (type.isMixin()) continue;
            list.add(type);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        ArrayList list = Lists.newArrayList();
        NodeTypeIterator iterator = this.getAllNodeTypes();
        while (iterator.hasNext()) {
            NodeType type = iterator.nextNodeType();
            if (!type.isMixin()) continue;
            list.add(type);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    public NodeTypeTemplate createNodeTypeTemplate() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeDefinitionTemplate createNodeDefinitionTemplate() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public PropertyDefinitionTemplate createPropertyDefinitionTemplate() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdate) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void unregisterNodeType(String name) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void unregisterNodeTypes(String[] names) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Override
    public boolean isNodeType(Tree tree, String oakNtName) {
        String name;
        if ("nt:base".equals(oakNtName)) {
            return true;
        }
        if ("mix:referenceable".equals(oakNtName) && !tree.hasProperty("jcr:uuid")) {
            return false;
        }
        if ("mix:versionable".equals(oakNtName) && !tree.hasProperty("jcr:isCheckedOut")) {
            return false;
        }
        Tree types = this.getTypes();
        PropertyState primary = tree.getProperty("jcr:primaryType");
        if (primary != null && primary.getType() == Type.NAME && ReadOnlyNodeTypeManager.isa(types, name = primary.getValue(Type.NAME), oakNtName)) {
            return true;
        }
        PropertyState mixins = tree.getProperty("jcr:mixinTypes");
        if (mixins != null && mixins.getType() == Type.NAMES) {
            for (String name2 : mixins.getValue(Type.NAMES)) {
                if (!ReadOnlyNodeTypeManager.isa(types, name2, oakNtName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isNodeType(@CheckForNull String primaryTypeName, @Nonnull Iterator<String> mixinTypes, @Nonnull String nodeTypeName) throws NoSuchNodeTypeException, RepositoryException {
        if ("nt:base".equals(nodeTypeName)) {
            return true;
        }
        Tree types = this.getTypes();
        if (primaryTypeName != null && ReadOnlyNodeTypeManager.isa(types, primaryTypeName, nodeTypeName)) {
            return true;
        }
        while (mixinTypes.hasNext()) {
            if (!ReadOnlyNodeTypeManager.isa(types, mixinTypes.next(), nodeTypeName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isa(Tree types, String typeName, String superName) {
        if (typeName.equals(superName)) {
            return true;
        }
        Tree type = types.getChild(typeName);
        if (!type.exists()) {
            return false;
        }
        PropertyState supertypes = type.getProperty("rep:supertypes");
        return supertypes != null && Iterables.contains(supertypes.getValue(Type.NAMES), (Object)superName);
    }

    @Override
    public boolean isNodeType(String typeName, String superName) {
        return ReadOnlyNodeTypeManager.isa(this.getTypes(), typeName, superName);
    }

    @Override
    public EffectiveNodeType getEffectiveNodeType(Node node) throws RepositoryException {
        NodeTypeImpl primary = (NodeTypeImpl)node.getPrimaryNodeType();
        NodeType[] mixins = node.getMixinNodeTypes();
        NodeTypeImpl[] mixinImpls = new NodeTypeImpl[mixins.length];
        for (int i = 0; i < mixins.length; ++i) {
            mixinImpls[i] = (NodeTypeImpl)mixins[i];
        }
        return new EffectiveNodeTypeImpl(primary, mixinImpls, this);
    }

    @Override
    public EffectiveNodeType getEffectiveNodeType(Tree tree) throws RepositoryException {
        PropertyState jcrPrimaryType = tree.getProperty("jcr:primaryType");
        if (jcrPrimaryType == null) {
            throw new RepositoryException("Node at " + tree.getPath() + " has no primary type.");
        }
        String ntName = jcrPrimaryType.getValue(Type.STRING);
        NodeTypeImpl primaryType = this.internalGetNodeType(ntName);
        PropertyState jcrMixinType = tree.getProperty("jcr:mixinTypes");
        if (jcrMixinType == null) {
            return new EffectiveNodeTypeImpl(primaryType, this);
        }
        NodeTypeImpl[] mixinTypes = new NodeTypeImpl[jcrMixinType.count()];
        for (int i = 0; i < mixinTypes.length; ++i) {
            mixinTypes[i] = this.internalGetNodeType(jcrMixinType.getValue(Type.NAME, i));
        }
        return new EffectiveNodeTypeImpl(primaryType, mixinTypes, this);
    }

    @Override
    @Nonnull
    public NodeDefinition getRootDefinition() throws RepositoryException {
        return new RootNodeDefinition(this);
    }

    @Override
    @Nonnull
    public NodeDefinition getDefinition(@Nonnull Tree parent, @Nonnull String nodeName) throws RepositoryException {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)nodeName);
        EffectiveNodeType effective = this.getEffectiveNodeType(parent);
        return effective.getNodeDefinition(nodeName, null);
    }

    @Override
    @Nonnull
    public NodeDefinition getDefinition(@Nonnull Tree parent, @Nonnull Tree targetNode) throws RepositoryException {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)targetNode);
        String name = PathUtils.dropIndexFromName(targetNode.getName());
        EffectiveNodeType eff = this.getEffectiveNodeType(parent);
        return eff.getNodeDefinition(name, this.getEffectiveNodeType(targetNode));
    }

    @Override
    @Nonnull
    public PropertyDefinition getDefinition(Tree parent, PropertyState property, boolean exactTypeMatch) throws RepositoryException {
        Type<?> type = property.getType();
        EffectiveNodeType effective = this.getEffectiveNodeType(parent);
        return effective.getPropertyDefinition(property.getName(), type.isArray(), type.tag(), exactTypeMatch);
    }

    NodeTypeImpl internalGetNodeType(String oakName) throws NoSuchNodeTypeException {
        Tree type;
        Tree types = this.getTypes();
        if (types != null && (type = types.getChild(oakName)).exists()) {
            return new NodeTypeImpl(type, this.getNamePathMapper());
        }
        throw new NoSuchNodeTypeException(this.getNamePathMapper().getJcrName(oakName));
    }
}

