/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.AccessControlValidator;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class AccessControlValidatorProvider
extends ValidatorProvider {
    private final SecurityProvider securityProvider;
    private final RootProvider rootProvider;
    private final TreeProvider treeProvider;

    public AccessControlValidatorProvider(@Nonnull SecurityProvider securityProvider, @Nonnull RootProvider rootProvider, @Nonnull TreeProvider treeProvider) {
        this.securityProvider = securityProvider;
        this.rootProvider = rootProvider;
        this.treeProvider = treeProvider;
    }

    @Override
    @Nonnull
    public Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        RestrictionProvider restrictionProvider = this.getConfig(AuthorizationConfiguration.class).getRestrictionProvider();
        Root root = this.rootProvider.createReadOnlyRoot(before);
        PrivilegeManager privilegeManager = this.getConfig(PrivilegeConfiguration.class).getPrivilegeManager(root, NamePathMapper.DEFAULT);
        PrivilegeBitsProvider privilegeBitsProvider = new PrivilegeBitsProvider(root);
        return new AccessControlValidator(after, privilegeManager, privilegeBitsProvider, restrictionProvider, this.treeProvider);
    }

    private <T> T getConfig(Class<T> configClass) {
        return this.securityProvider.getConfiguration(configClass);
    }
}

