/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.apache.jackrabbit.oak.spi.xml.NodeInfo;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.ProtectedNodeImporter;
import org.apache.jackrabbit.oak.spi.xml.ProtectedPropertyImporter;
import org.apache.jackrabbit.oak.spi.xml.ReferenceChangeTracker;
import org.apache.jackrabbit.oak.spi.xml.TextValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserImporter
implements ProtectedPropertyImporter,
ProtectedNodeImporter,
UserConstants {
    private static final Logger log = LoggerFactory.getLogger(UserImporter.class);
    private final int importBehavior;
    private Root root;
    private NamePathMapper namePathMapper;
    private ReferenceChangeTracker referenceTracker;
    private UserManagerImpl userManager;
    private IdentifierManager identifierManager;
    private boolean initialized = false;
    private Membership currentMembership;
    private Map<String, Membership> memberships = new HashMap<String, Membership>();
    private String currentPw;
    private Map<String, Principal> principals = new HashMap<String, Principal>();

    UserImporter(ConfigurationParameters config) {
        this.importBehavior = UserUtil.getImportBehavior(config);
    }

    @Override
    public boolean init(@Nonnull Session session, @Nonnull Root root, @Nonnull NamePathMapper namePathMapper, boolean isWorkspaceImport, int uuidBehavior, @Nonnull ReferenceChangeTracker referenceTracker, @Nonnull SecurityProvider securityProvider) {
        if (!(session instanceof JackrabbitSession)) {
            log.debug("Importing protected user content requires a JackrabbitSession");
            return false;
        }
        this.root = root;
        this.namePathMapper = namePathMapper;
        this.referenceTracker = referenceTracker;
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        if (uuidBehavior == 0) {
            log.debug("ImportUUIDBehavior.IMPORT_UUID_CREATE_NEW isn't supported when importing users or groups.");
            return false;
        }
        if (!UserImporter.canInitUserManager((JackrabbitSession)session, isWorkspaceImport, securityProvider)) {
            return false;
        }
        this.userManager = new UserManagerImpl(root, namePathMapper, securityProvider);
        this.initialized = true;
        return this.initialized;
    }

    private static boolean canInitUserManager(@Nonnull JackrabbitSession session, boolean isWorkspaceImport, @Nonnull SecurityProvider securityProvider) {
        try {
            if (!isWorkspaceImport && session.getUserManager().isAutoSave()) {
                log.warn("Session import cannot handle user content: UserManager is in autosave mode.");
                return false;
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to initialize UserImporter: ", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean handlePropInfo(@Nonnull Tree parent, @Nonnull PropInfo propInfo, @Nonnull PropertyDefinition def) throws RepositoryException {
        this.checkInitialized();
        String propName = propInfo.getName();
        if (UserImporter.isPwdNode(parent)) {
            return UserImporter.importPwdNodeProperty(parent, propInfo, def);
        }
        Authorizable a = this.userManager.getAuthorizable(parent);
        if (a == null) {
            log.debug("Cannot handle protected PropInfo " + propInfo + ". Node " + parent + " doesn't represent an Authorizable.");
            return false;
        }
        if ("rep:authorizableId".equals(propName)) {
            if (!this.isValid(def, "rep:Authorizable", false)) {
                return false;
            }
            String id = propInfo.getTextValue().getString();
            Authorizable existing = this.userManager.getAuthorizable(id);
            if (existing == null) {
                String msg = "Cannot handle protected PropInfo " + propInfo + ". Invalid rep:authorizableId.";
                log.warn(msg);
                throw new ConstraintViolationException(msg);
            }
            if (!a.getPath().equals(existing.getPath())) {
                throw new AuthorizableExistsException(id);
            }
            parent.setProperty("rep:authorizableId", id);
            return true;
        }
        if ("rep:principalName".equals(propName)) {
            if (!this.isValid(def, "rep:Authorizable", false)) {
                return false;
            }
            String principalName = propInfo.getTextValue().getString();
            PrincipalImpl principal = new PrincipalImpl(principalName);
            this.userManager.checkValidPrincipal(principal, a.isGroup());
            this.userManager.setPrincipal(parent, principal);
            if (this.principals == null) {
                this.principals = new HashMap<String, Principal>();
            }
            this.principals.put(principalName, a.getPrincipal());
            return true;
        }
        if ("rep:password".equals(propName)) {
            if (a.isGroup() || !this.isValid(def, "rep:User", false)) {
                log.warn("Unexpected authorizable or definition for property rep:password");
                return false;
            }
            if (((User)a).isSystemUser()) {
                log.warn("System users may not have a password set.");
                return false;
            }
            String pw = propInfo.getTextValue().getString();
            this.userManager.setPassword(parent, a.getID(), pw, false);
            this.currentPw = pw;
            return true;
        }
        if ("rep:impersonators".equals(propName)) {
            if (a.isGroup() || !this.isValid(def, "rep:Impersonatable", true)) {
                log.warn("Unexpected authorizable or definition for property rep:impersonators");
                return false;
            }
            this.referenceTracker.processedReference(new Impersonators(parent.getPath(), propInfo.getTextValues()));
            return true;
        }
        if ("rep:disabled".equals(propName)) {
            if (a.isGroup() || !this.isValid(def, "rep:User", false)) {
                log.warn("Unexpected authorizable or definition for property rep:disabled");
                return false;
            }
            ((User)a).disable(propInfo.getTextValue().getString());
            return true;
        }
        if ("rep:members".equals(propName)) {
            if (!a.isGroup() || !this.isValid(def, "rep:MemberReferences", true)) {
                return false;
            }
            this.getMembership(a.getPath()).addMembers(propInfo.getTextValues());
            return true;
        }
        return false;
    }

    @Override
    public void propertiesCompleted(@Nonnull Tree protectedParent) throws RepositoryException {
        if (UserImporter.isCacheNode(protectedParent)) {
            protectedParent.remove();
        } else {
            Authorizable a = this.userManager.getAuthorizable(protectedParent);
            if (a == null) {
                return;
            }
            if (!protectedParent.hasProperty("rep:authorizableId")) {
                protectedParent.setProperty("rep:authorizableId", a.getID(), Type.STRING);
            }
            if (protectedParent.getStatus() == Tree.Status.NEW) {
                if (a.isGroup()) {
                    this.userManager.onCreate((Group)a);
                } else {
                    this.userManager.onCreate((User)a, this.currentPw);
                }
            }
            this.currentPw = null;
        }
    }

    @Override
    public void processReferences() throws RepositoryException {
        this.checkInitialized();
        for (Membership m : this.memberships.values()) {
            this.referenceTracker.processedReference(m);
        }
        this.memberships.clear();
        ArrayList<Object> processed = new ArrayList<Object>();
        Iterator<Object> it = this.referenceTracker.getProcessedReferences();
        while (it.hasNext()) {
            Object reference = it.next();
            if (reference instanceof Membership) {
                ((Membership)reference).process();
                processed.add(reference);
                continue;
            }
            if (!(reference instanceof Impersonators)) continue;
            ((Impersonators)reference).process();
            processed.add(reference);
        }
        this.referenceTracker.removeReferences(processed);
    }

    @Override
    public boolean start(@Nonnull Tree protectedParent) throws RepositoryException {
        Authorizable auth = null;
        if (UserImporter.isMemberNode(protectedParent)) {
            Tree groupTree = protectedParent;
            while (UserImporter.isMemberNode(groupTree) && !groupTree.isRoot()) {
                groupTree = groupTree.getParent();
            }
            auth = this.userManager.getAuthorizable(groupTree);
        } else if (UserImporter.isMemberReferencesListNode(protectedParent)) {
            auth = this.userManager.getAuthorizable(protectedParent.getParent());
        }
        if (auth == null || !auth.isGroup()) {
            log.debug("Cannot handle protected node " + protectedParent + ". It nor one of its parents represent a valid Group.");
            return false;
        }
        this.currentMembership = this.getMembership(auth.getPath());
        return true;
    }

    @Override
    public void startChildInfo(@Nonnull NodeInfo childInfo, @Nonnull List<PropInfo> propInfos) throws RepositoryException {
        Preconditions.checkState((this.currentMembership != null ? 1 : 0) != 0);
        String ntName = childInfo.getPrimaryTypeName();
        if ("rep:Members".equals(ntName)) {
            for (PropInfo prop : propInfos) {
                for (TextValue textValue : prop.getTextValues()) {
                    this.currentMembership.addMember(textValue.getString());
                }
            }
        } else if ("rep:MemberReferences".equals(ntName)) {
            for (PropInfo prop : propInfos) {
                if (!"rep:members".equals(prop.getName())) continue;
                this.currentMembership.addMembers(prop.getTextValues());
            }
        } else {
            log.warn("{} is not of type rep:Members or rep:MemberReferences", (Object)childInfo.getName());
        }
    }

    @Override
    public void endChildInfo() throws RepositoryException {
    }

    @Override
    public void end(@Nonnull Tree protectedParent) throws RepositoryException {
        this.currentMembership = null;
    }

    @Nonnull
    private IdentifierManager getIdentifierManager() {
        if (this.identifierManager == null) {
            this.identifierManager = new IdentifierManager(this.root);
        }
        return this.identifierManager;
    }

    @Nonnull
    private PrincipalManager getPrincipalManager() throws RepositoryException {
        return this.userManager.getPrincipalManager();
    }

    @Nonnull
    private Membership getMembership(@Nonnull String authId) {
        Membership membership = this.memberships.get(authId);
        if (membership == null) {
            membership = new Membership(authId);
            this.memberships.put(authId, membership);
        }
        return membership;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
    }

    private boolean isValid(@Nonnull PropertyDefinition definition, @Nonnull String oakNodeTypeName, boolean multipleStatus) {
        return multipleStatus == definition.isMultiple() && definition.getDeclaringNodeType().isNodeType(this.namePathMapper.getJcrName(oakNodeTypeName));
    }

    private static boolean isMemberNode(@Nonnull Tree tree) {
        return tree.exists() && "rep:Members".equals(TreeUtil.getPrimaryTypeName(tree));
    }

    private static boolean isMemberReferencesListNode(@Nonnull Tree tree) {
        return tree.exists() && "rep:MemberReferencesList".equals(TreeUtil.getPrimaryTypeName(tree));
    }

    private static boolean isPwdNode(@Nonnull Tree tree) {
        return "rep:pwd".equals(tree.getName()) && "rep:Password".equals(TreeUtil.getPrimaryTypeName(tree));
    }

    private static boolean importPwdNodeProperty(@Nonnull Tree parent, @Nonnull PropInfo propInfo, @Nonnull PropertyDefinition def) throws RepositoryException {
        String propName = propInfo.getName();
        if (propName == null && ((propName = def.getName()) == null || "*".equals(propName))) {
            return false;
        }
        int targetType = def.getRequiredType();
        if (targetType == 0) {
            targetType = "rep:passwordLastModified".equals(propName) ? 3 : 1;
        }
        PropertyState property = def.isMultiple() ? PropertyStates.createProperty(propName, propInfo.getValues(targetType)) : PropertyStates.createProperty(propName, propInfo.getValue(targetType));
        parent.setProperty(property);
        return true;
    }

    private static boolean isCacheNode(@Nonnull Tree tree) {
        return tree.exists() && "rep:cache".equals(tree.getName()) && "rep:Cache".equals(TreeUtil.getPrimaryTypeName(tree));
    }

    private void handleFailure(String msg) throws ConstraintViolationException {
        switch (this.importBehavior) {
            case 1: 
            case 2: {
                log.warn(msg);
                break;
            }
            case 3: {
                throw new ConstraintViolationException(msg);
            }
        }
    }

    private final class Impersonators {
        private final String userPath;
        private final Set<String> principalNames = new HashSet<String>();

        private Impersonators(String userPath, List<? extends TextValue> values) {
            this.userPath = userPath;
            for (TextValue textValue : values) {
                this.principalNames.add(textValue.getString());
            }
        }

        private void process() throws RepositoryException {
            Authorizable a = UserImporter.this.userManager.getAuthorizableByOakPath(this.userPath);
            if (a == null || a.isGroup()) {
                throw new RepositoryException(this.userPath + " does not represent a valid user.");
            }
            Impersonation imp = (Impersonation)Preconditions.checkNotNull((Object)((User)a).getImpersonation());
            HashMap<String, Principal> toRemove = new HashMap<String, Principal>();
            PrincipalIterator pit = imp.getImpersonators();
            while (pit.hasNext()) {
                Iterator p = pit.nextPrincipal();
                toRemove.put(p.getName(), (Principal)((Object)p));
            }
            ArrayList<String> toAdd = new ArrayList<String>();
            for (String principalName : this.principalNames) {
                if (toRemove.remove(principalName) != null) continue;
                toAdd.add(principalName);
            }
            for (Object p : toRemove.values()) {
                if (imp.revokeImpersonation((Principal)p)) continue;
                String principalName = p.getName();
                UserImporter.this.handleFailure("Failed to revoke impersonation for " + principalName + " on " + a);
            }
            ArrayList<String> nonExisting = new ArrayList<String>();
            for (String principalName : toAdd) {
                Principal principal = UserImporter.this.principals.containsKey(principalName) ? (Principal)UserImporter.this.principals.get(principalName) : new PrincipalImpl(principalName);
                if (imp.grantImpersonation(principal)) continue;
                UserImporter.this.handleFailure("Failed to grant impersonation for " + principalName + " on " + a);
                if (UserImporter.this.importBehavior != 2 || UserImporter.this.getPrincipalManager().getPrincipal(principalName) != null) continue;
                log.debug("ImportBehavior.BESTEFFORT: Remember non-existing impersonator for special processing.");
                nonExisting.add(principalName);
            }
            if (!nonExisting.isEmpty()) {
                Tree userTree = (Tree)Preconditions.checkNotNull((Object)UserImporter.this.root.getTree(a.getPath()));
                PropertyState impersonators = userTree.getProperty("rep:impersonators");
                if (impersonators != null) {
                    for (String existing : impersonators.getValue(Type.STRINGS)) {
                        nonExisting.add(existing);
                    }
                }
                userTree.setProperty("rep:impersonators", nonExisting, Type.STRINGS);
            }
        }
    }

    private final class Membership {
        private final String authorizablePath;
        private final Set<String> members = new TreeSet<String>();

        Membership(String authorizablePath) {
            this.authorizablePath = authorizablePath;
        }

        void addMember(String id) {
            this.members.add(id);
        }

        void addMembers(List<? extends TextValue> tvs) {
            for (TextValue textValue : tvs) {
                this.addMember(textValue.getString());
            }
        }

        void process() throws RepositoryException {
            Set<String> failed;
            Authorizable a = UserImporter.this.userManager.getAuthorizableByPath(this.authorizablePath);
            if (a == null || !a.isGroup()) {
                throw new RepositoryException(this.authorizablePath + " does not represent a valid group.");
            }
            Group gr = (Group)a;
            HashMap<String, Authorizable> toRemove = new HashMap<String, Authorizable>();
            Iterator<Authorizable> declMembers = gr.getDeclaredMembers();
            while (declMembers.hasNext()) {
                Authorizable dm = declMembers.next();
                toRemove.put(dm.getID(), dm);
            }
            HashMap toAdd = Maps.newHashMapWithExpectedSize((int)this.members.size());
            HashMap nonExisting = Maps.newHashMap();
            for (String contentId : this.members) {
                String remapped = UserImporter.this.referenceTracker.get(contentId);
                String memberContentId = remapped == null ? contentId : remapped;
                Authorizable member = null;
                try {
                    Tree n = UserImporter.this.getIdentifierManager().getTree(memberContentId);
                    member = UserImporter.this.userManager.getAuthorizable(n);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                if (member != null) {
                    if (toRemove.remove(member.getID()) != null) continue;
                    toAdd.put(member.getID(), member);
                    continue;
                }
                UserImporter.this.handleFailure("New member of " + gr + ": No such authorizable (NodeID = " + memberContentId + ')');
                if (UserImporter.this.importBehavior != 2) continue;
                log.debug("ImportBehavior.BESTEFFORT: Remember non-existing member for processing.");
                nonExisting.put(contentId, "-");
            }
            if (!toRemove.isEmpty() && !(failed = gr.removeMembers(toRemove.keySet().toArray(new String[toRemove.size()]))).isEmpty()) {
                UserImporter.this.handleFailure("Failed removing members " + Iterables.toString(failed) + " to " + gr);
            }
            if (!toAdd.isEmpty() && !(failed = gr.addMembers(toAdd.keySet().toArray(new String[toAdd.size()]))).isEmpty()) {
                UserImporter.this.handleFailure("Failed add members " + Iterables.toString(failed) + " to " + gr);
            }
            if (!nonExisting.isEmpty()) {
                log.debug("ImportBehavior.BESTEFFORT: Found " + nonExisting.size() + " entries of rep:members pointing to non-existing authorizables. Adding to rep:members.");
                Tree groupTree = UserImporter.this.root.getTree(gr.getPath());
                MembershipProvider membershipProvider = UserImporter.this.userManager.getMembershipProvider();
                HashSet memberContentIds = Sets.newHashSet(nonExisting.keySet());
                Set<String> failedContentIds = membershipProvider.addMembers(groupTree, nonExisting);
                memberContentIds.removeAll(failedContentIds);
                UserImporter.this.userManager.onGroupUpdate(gr, false, true, memberContentIds, failedContentIds);
            }
        }
    }
}

