/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.util.Text;

class Utils {
    private Utils() {
    }

    @Nonnull
    static Tree getOrAddTree(@Nonnull Tree tree, @Nonnull String relativePath, @Nonnull String primaryTypeName) throws AccessDeniedException {
        if (PathUtils.denotesCurrent(relativePath)) {
            return tree;
        }
        if (PathUtils.denotesParent(relativePath)) {
            return tree.getParent();
        }
        if (relativePath.indexOf(47) == -1) {
            return TreeUtil.getOrAddChild(tree, relativePath, primaryTypeName);
        }
        Tree t = TreeUtil.getTree(tree, relativePath);
        if (t == null || !t.exists()) {
            Tree target = tree;
            for (String segment : Text.explode(relativePath, 47)) {
                if (PathUtils.denotesParent(segment)) {
                    target = target.getParent();
                    continue;
                }
                if (target.hasChild(segment)) {
                    target = target.getChild(segment);
                    continue;
                }
                if (PathUtils.denotesCurrent(segment)) continue;
                target = TreeUtil.addChild(target, segment, primaryTypeName);
            }
            if (!target.exists()) {
                throw new AccessDeniedException();
            }
            return target;
        }
        return t;
    }
}

