/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.credentials;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.oak.spi.security.authentication.credentials.CredentialsSupport;

public final class SimpleCredentialsSupport
implements CredentialsSupport {
    private static final SimpleCredentialsSupport INSTANCE = new SimpleCredentialsSupport();

    private SimpleCredentialsSupport() {
    }

    public static CredentialsSupport getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public ImmutableSet<Class> getCredentialClasses() {
        return ImmutableSet.of(SimpleCredentials.class);
    }

    @Override
    @CheckForNull
    public String getUserId(@Nonnull Credentials credentials) {
        if (credentials instanceof SimpleCredentials) {
            return ((SimpleCredentials)credentials).getUserID();
        }
        return null;
    }

    @Override
    @Nonnull
    public Map<String, ?> getAttributes(@Nonnull Credentials credentials) {
        if (credentials instanceof SimpleCredentials) {
            final SimpleCredentials sc = (SimpleCredentials)credentials;
            return Maps.asMap((Set)ImmutableSet.copyOf((Object[])sc.getAttributeNames()), (Function)new Function<String, Object>(){

                @Nullable
                public Object apply(String input) {
                    return sc.getAttribute(input);
                }
            });
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean setAttributes(@Nonnull Credentials credentials, @Nonnull Map<String, ?> attributes) {
        if (credentials instanceof SimpleCredentials) {
            SimpleCredentials sc = (SimpleCredentials)credentials;
            for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                sc.setAttribute(entry.getKey(), entry.getValue());
            }
            return true;
        }
        return false;
    }
}

