/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.ResetCommitAttributeHook;
import org.apache.jackrabbit.oak.spi.commit.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public final class OakInitializer {
    public static final String SESSION_ID = "OakInitializer";

    private OakInitializer() {
    }

    public static void initialize(@Nonnull NodeStore store, @Nonnull RepositoryInitializer initializer, @Nonnull IndexEditorProvider indexEditor) {
        try {
            NodeBuilder builder = store.getRoot().builder();
            initializer.initialize(builder);
            store.merge(builder, OakInitializer.createHook(indexEditor), OakInitializer.createCommitInfo());
        }
        catch (CommitFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void initialize(@Nonnull Iterable<WorkspaceInitializer> initializer, @Nonnull NodeStore store, @Nonnull String workspaceName, @Nonnull IndexEditorProvider indexEditor) {
        NodeBuilder builder = store.getRoot().builder();
        for (WorkspaceInitializer wspInit : initializer) {
            wspInit.initialize(builder, workspaceName);
        }
        try {
            store.merge(builder, OakInitializer.createHook(indexEditor), OakInitializer.createCommitInfo());
        }
        catch (CommitFailedException e) {
            throw new RuntimeException(e);
        }
    }

    private static CommitHook createHook(@Nonnull IndexEditorProvider indexEditor) {
        return new CompositeHook(ResetCommitAttributeHook.INSTANCE, new EditorHook(new IndexUpdateProvider(indexEditor)));
    }

    private static CommitInfo createCommitInfo() {
        ImmutableMap infoMap = ImmutableMap.of((Object)"oak.commitAttributes", (Object)new SimpleCommitContext());
        return new CommitInfo(SESSION_ID, null, (Map<String, Object>)infoMap);
    }
}

