/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;

public abstract class ConfigurationBase
extends SecurityConfiguration.Default {
    private SecurityProvider securityProvider;
    private ConfigurationParameters config = ConfigurationParameters.EMPTY;
    private RootProvider rootProvider;
    private TreeProvider treeProvider;

    public ConfigurationBase() {
    }

    public ConfigurationBase(@Nonnull SecurityProvider securityProvider, @Nonnull ConfigurationParameters config) {
        this.securityProvider = securityProvider;
        this.config = config;
    }

    @Nonnull
    public SecurityProvider getSecurityProvider() {
        if (this.securityProvider == null) {
            throw new IllegalStateException();
        }
        return this.securityProvider;
    }

    public void setSecurityProvider(@Nonnull SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public void setParameters(@Nonnull ConfigurationParameters config) {
        this.config = config;
    }

    public void setRootProvider(@Nonnull RootProvider rootProvider) {
        this.rootProvider = rootProvider;
    }

    @Nonnull
    public RootProvider getRootProvider() {
        if (this.rootProvider == null) {
            throw new IllegalStateException("RootProvider missing.");
        }
        return this.rootProvider;
    }

    public void setTreeProvider(@Nonnull TreeProvider treeProvider) {
        this.treeProvider = treeProvider;
    }

    @Nonnull
    public TreeProvider getTreeProvider() {
        if (this.treeProvider == null) {
            throw new IllegalStateException("TreeProvider missing.");
        }
        return this.treeProvider;
    }

    @Override
    @Nonnull
    public ConfigurationParameters getParameters() {
        return this.config;
    }
}

