/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.jcr.delegate.GroupDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.UserDelegator;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AuthorizableDelegator
implements Authorizable {
    final SessionDelegate sessionDelegate;
    final Authorizable delegate;

    AuthorizableDelegator(@NotNull SessionDelegate sessionDelegate, @NotNull Authorizable delegate) {
        Preconditions.checkArgument((!(delegate instanceof AuthorizableDelegator) ? 1 : 0) != 0);
        this.sessionDelegate = sessionDelegate;
        this.delegate = delegate;
    }

    static Authorizable wrap(@NotNull SessionDelegate sessionDelegate, @Nullable Authorizable authorizable) {
        if (authorizable == null) {
            return null;
        }
        if (authorizable.isGroup()) {
            return GroupDelegator.wrap(sessionDelegate, (Group)authorizable);
        }
        return UserDelegator.wrap(sessionDelegate, (User)authorizable);
    }

    static Authorizable unwrap(@NotNull Authorizable authorizable) {
        if (authorizable.isGroup()) {
            return GroupDelegator.unwrap((Group)authorizable);
        }
        return UserDelegator.unwrap((User)authorizable);
    }

    public boolean isGroup() {
        return this.sessionDelegate.safePerform(new SessionOperation<Boolean>("isGroup"){

            @Override
            @NotNull
            public Boolean perform() {
                return AuthorizableDelegator.this.delegate.isGroup();
            }
        });
    }

    public String getID() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<String>("getID"){

            @Override
            @NotNull
            public String perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getID();
            }
        });
    }

    public Principal getPrincipal() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Principal>("getPrincipal"){

            @Override
            @NotNull
            public Principal perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getPrincipal();
            }
        });
    }

    public Iterator<Group> declaredMemberOf() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<Group>>("declaredMemberOf"){

            @Override
            @NotNull
            public Iterator<Group> perform() throws RepositoryException {
                Iterator groups = AuthorizableDelegator.this.delegate.declaredMemberOf();
                return Iterators.transform((Iterator)groups, (Function)new Function<Group, Group>(){

                    @Nullable
                    public Group apply(@Nullable Group group) {
                        return GroupDelegator.wrap(AuthorizableDelegator.this.sessionDelegate, group);
                    }
                });
            }
        });
    }

    public Iterator<Group> memberOf() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<Group>>("memberOf"){

            @Override
            @NotNull
            public Iterator<Group> perform() throws RepositoryException {
                Iterator groups = AuthorizableDelegator.this.delegate.memberOf();
                return Iterators.transform((Iterator)groups, (Function)new Function<Group, Group>(){

                    @Nullable
                    public Group apply(@Nullable Group group) {
                        return GroupDelegator.wrap(AuthorizableDelegator.this.sessionDelegate, group);
                    }
                });
            }
        });
    }

    public void remove() throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("remove", true){

            @Override
            public void performVoid() throws RepositoryException {
                AuthorizableDelegator.this.delegate.remove();
            }
        });
    }

    public Iterator<String> getPropertyNames() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<String>>("getPropertyNames"){

            @Override
            @NotNull
            public Iterator<String> perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getPropertyNames();
            }
        });
    }

    public Iterator<String> getPropertyNames(final String relPath) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Iterator<String>>("getPropertyNames"){

            @Override
            @NotNull
            public Iterator<String> perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getPropertyNames(relPath);
            }
        });
    }

    public boolean hasProperty(final String relPath) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("hasProperty"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.hasProperty(relPath);
            }
        });
    }

    public void setProperty(final String relPath, final Value value) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("setProperty", true){

            @Override
            public void performVoid() throws RepositoryException {
                AuthorizableDelegator.this.delegate.setProperty(relPath, value);
            }
        });
    }

    public void setProperty(final String relPath, final Value[] value) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("setProperty", true){

            @Override
            public void performVoid() throws RepositoryException {
                AuthorizableDelegator.this.delegate.setProperty(relPath, value);
            }
        });
    }

    public Value[] getProperty(final String relPath) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Value[]>("getProperty"){

            @Override
            @NotNull
            public Value[] perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getProperty(relPath);
            }
        });
    }

    public boolean removeProperty(final String relPath) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("removeProperty", true){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.removeProperty(relPath);
            }
        });
    }

    public String getPath() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<String>("getPath"){

            @Override
            @NotNull
            public String perform() throws RepositoryException {
                return AuthorizableDelegator.this.delegate.getPath();
            }
        });
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AuthorizableDelegator) {
            AuthorizableDelegator ad = (AuthorizableDelegator)other;
            return this.delegate.equals(ad.delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

