/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.xml;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.NamespaceHelper;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.xml.DocViewImportHandler;
import org.apache.jackrabbit.oak.jcr.xml.ImporterImpl;
import org.apache.jackrabbit.oak.jcr.xml.SysViewImportHandler;
import org.apache.jackrabbit.oak.jcr.xml.TargetImportHandler;
import org.apache.jackrabbit.oak.spi.xml.Importer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportHandler
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(ImportHandler.class);
    private final Root root;
    private final SessionContext sessionContext;
    private final Importer importer;
    private final boolean isWorkspaceImport;
    protected Locator locator;
    private TargetImportHandler targetHandler;
    private final Map<String, String> tempPrefixMap = new HashMap<String, String>();

    public ImportHandler(String absPath, SessionContext sessionContext, int uuidBehavior, boolean isWorkspaceImport) throws RepositoryException {
        this.sessionContext = sessionContext;
        this.isWorkspaceImport = isWorkspaceImport;
        SessionDelegate sd = sessionContext.getSessionDelegate();
        this.root = isWorkspaceImport ? sd.getContentSession().getLatestRoot() : sd.getRoot();
        this.importer = new ImporterImpl(absPath, sessionContext, this.root, uuidBehavior, isWorkspaceImport);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        log.warn("warning encountered at line: {}, column: {} while parsing XML stream", new Object[]{e.getLineNumber(), e.getColumnNumber(), e});
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        log.error("error encountered at line: {}, column: {} while parsing XML stream", new Object[]{e.getLineNumber(), e.getColumnNumber(), e});
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        log.error("fatal error encountered at line: {}, column: {} while parsing XML stream", new Object[]{e.getLineNumber(), e.getColumnNumber(), e});
        throw e;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.targetHandler != null) {
            this.targetHandler.endDocument();
        }
        if (this.isWorkspaceImport) {
            try {
                this.root.commit();
                this.sessionContext.getSession().refresh(false);
            }
            catch (CommitFailedException e) {
                throw new SAXException(e);
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            new NamespaceHelper((Session)this.sessionContext.getSession()).registerNamespace(prefix, uri);
            if (this.targetHandler != null) {
                this.targetHandler.startPrefixMapping(prefix, uri);
            } else {
                this.tempPrefixMap.put(prefix, uri);
            }
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.targetHandler != null) {
            this.targetHandler.endPrefixMapping(prefix);
        } else {
            this.tempPrefixMap.remove(prefix);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.targetHandler == null) {
            this.targetHandler = "http://www.jcp.org/jcr/sv/1.0".equals(namespaceURI) ? new SysViewImportHandler(this.importer, this.sessionContext) : new DocViewImportHandler(this.importer, this.sessionContext);
            this.targetHandler.startDocument();
            for (Map.Entry<String, String> prefixMapping : this.tempPrefixMap.entrySet()) {
                this.targetHandler.startPrefixMapping(prefixMapping.getKey(), prefixMapping.getValue());
            }
        }
        this.targetHandler.startElement(namespaceURI, localName, qName, atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.targetHandler.characters(ch, start, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.targetHandler.endElement(namespaceURI, localName, qName);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

