/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.value.BinaryBasedBlob;
import org.apache.jackrabbit.oak.plugins.value.OakValue;

public abstract class AbstractPropertyState
implements PropertyState {
    public static boolean equal(PropertyState a, PropertyState b) {
        if (Objects.equal((Object)a.getName(), (Object)b.getName()) && Objects.equal(a.getType(), b.getType())) {
            Type<?> type = a.getType();
            if (a.isArray()) {
                return a.count() == b.count() && Iterables.elementsEqual((Iterable)((Iterable)a.getValue(type)), (Iterable)((Iterable)b.getValue(type)));
            }
            return Objects.equal(a.getValue(type), b.getValue(type));
        }
        return false;
    }

    public static int hashCode(PropertyState property) {
        return property.getName().hashCode();
    }

    public static String toString(PropertyState property) {
        String name = property.getName();
        Type<?> type = property.getType();
        if (type == Type.BINARIES) {
            return name + " = [" + property.count() + " binaries]";
        }
        if (type == Type.BINARY) {
            return name + " = {" + AbstractPropertyState.getBinarySize(property) + " bytes}";
        }
        return name + " = " + property.getValue(type);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PropertyState && AbstractPropertyState.equal(this, (PropertyState)other);
    }

    public int hashCode() {
        return AbstractPropertyState.hashCode(this);
    }

    public String toString() {
        return AbstractPropertyState.toString(this);
    }

    private static long getBinarySize(PropertyState property) {
        try {
            return property.size();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    static Blob getBlob(Value value) throws RepositoryException {
        if (value instanceof OakValue) {
            return ((OakValue)value).getBlob();
        }
        return new BinaryBasedBlob(value.getBinary());
    }
}

