/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.constraint;

import com.google.common.base.Predicate;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameConstraint
implements Predicate<Value> {
    private static final Logger log = LoggerFactory.getLogger(NameConstraint.class);
    private final String requiredValue;

    public NameConstraint(String definition) {
        this.requiredValue = definition;
    }

    public boolean apply(@Nullable Value value) {
        try {
            return value != null && this.requiredValue != null && this.requiredValue.equals(value.getString());
        }
        catch (RepositoryException e) {
            log.warn("Error checking name constraint " + this, (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return '\'' + this.requiredValue + '\'';
    }
}

