/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ChildOrderDiff {
    private ChildOrderDiff() {
    }

    @Nullable
    static String firstReordered(@NotNull PropertyState before, @NotNull PropertyState after) {
        LinkedHashSet afterNames = Sets.newLinkedHashSet(after.getValue(Type.NAMES));
        LinkedHashSet beforeNames = Sets.newLinkedHashSet(before.getValue(Type.NAMES));
        Iterator a = afterNames.iterator();
        Iterator b = beforeNames.iterator();
        while (a.hasNext() && b.hasNext()) {
            String aName = (String)a.next();
            String bName = (String)b.next();
            while (!aName.equals(bName)) {
                if (!beforeNames.contains(aName)) {
                    if (a.hasNext()) {
                        aName = (String)a.next();
                        continue;
                    }
                    return null;
                }
                if (!afterNames.contains(bName)) {
                    if (b.hasNext()) {
                        bName = (String)b.next();
                        continue;
                    }
                    return null;
                }
                return aName;
            }
        }
        return null;
    }
}

