/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.security.authorization.permission.EntryPredicate;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionCache;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionCacheBuilder;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntryProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.jetbrains.annotations.NotNull;

class PermissionEntryProviderImpl
implements PermissionEntryProvider {
    private static final String EAGER_CACHE_SIZE_PARAM = "eagerCacheSize";
    private static final long DEFAULT_SIZE = 250L;
    private final Set<String> principalNames;
    private final PermissionStore store;
    private final long maxSize;
    private boolean noExistingNames;
    private PermissionCache permissionCache;

    PermissionEntryProviderImpl(@NotNull PermissionStore store, @NotNull Set<String> principalNames, @NotNull ConfigurationParameters options) {
        this.store = store;
        this.principalNames = Collections.unmodifiableSet(principalNames);
        this.maxSize = options.getConfigValue(EAGER_CACHE_SIZE_PARAM, 250L);
        this.init();
    }

    private void init() {
        PermissionCacheBuilder builder = new PermissionCacheBuilder(this.store);
        this.noExistingNames = builder.init(this.principalNames, this.maxSize);
        this.permissionCache = builder.build();
    }

    @Override
    public void flush() {
        this.init();
    }

    @Override
    @NotNull
    public Iterator<PermissionEntry> getEntryIterator(@NotNull EntryPredicate predicate) {
        if (this.noExistingNames) {
            return Collections.emptyIterator();
        }
        return new EntryIterator(predicate);
    }

    @Override
    @NotNull
    public Collection<PermissionEntry> getEntries(@NotNull Tree accessControlledTree) {
        return this.permissionCache.getEntries(accessControlledTree);
    }

    @NotNull
    private Collection<PermissionEntry> getEntries(@NotNull String path) {
        return this.permissionCache.getEntries(path);
    }

    private final class EntryIterator
    extends AbstractLazyIterator<PermissionEntry> {
        private final EntryPredicate predicate;
        private Iterator<PermissionEntry> nextEntries = Collections.emptyIterator();
        private String path;

        private EntryIterator(EntryPredicate predicate) {
            this.predicate = predicate;
            this.path = Strings.nullToEmpty((String)predicate.getPath());
        }

        @Override
        protected PermissionEntry getNext() {
            PermissionEntry next = null;
            while (next == null) {
                if (this.nextEntries.hasNext()) {
                    PermissionEntry pe = this.nextEntries.next();
                    if (!this.predicate.apply(pe)) continue;
                    next = pe;
                    continue;
                }
                if (this.path == null) break;
                this.nextEntries = PermissionEntryProviderImpl.this.getEntries(this.path).iterator();
                this.path = PermissionUtil.getParentPathOrNull(this.path);
            }
            return next;
        }
    }
}

