/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.version.VersionConstants;
import org.jetbrains.annotations.NotNull;

class VersionTreePermission
implements TreePermission,
VersionConstants {
    private static final Set<String> NT_NAMES = ImmutableSet.of((Object)"nt:version", (Object)"nt:versionLabels");
    private final Tree versionTree;
    private final TreePermission versionablePermission;
    private final TreeProvider treeProvider;

    VersionTreePermission(@NotNull Tree versionTree, @NotNull TreePermission versionablePermission, @NotNull TreeProvider treeProvider) {
        this.versionTree = versionTree;
        this.versionablePermission = versionablePermission;
        this.treeProvider = treeProvider;
    }

    @NotNull
    VersionTreePermission createChildPermission(@NotNull Tree versionTree) {
        TreePermission delegatee = "jcr:frozenNode".equals(versionTree.getName()) || NT_NAMES.contains(TreeUtil.getPrimaryTypeName(versionTree)) ? this.versionablePermission : this.versionablePermission.getChildPermission(versionTree.getName(), this.treeProvider.asNodeState(versionTree));
        return new VersionTreePermission(versionTree, delegatee, this.treeProvider);
    }

    @Override
    @NotNull
    public TreePermission getChildPermission(@NotNull String childName, @NotNull NodeState childState) {
        return this.createChildPermission(this.treeProvider.createReadOnlyTree(this.versionTree, childName, childState));
    }

    @Override
    public boolean canRead() {
        return this.versionablePermission.canRead();
    }

    @Override
    public boolean canRead(@NotNull PropertyState property) {
        return this.versionablePermission.canRead(property);
    }

    @Override
    public boolean canReadAll() {
        return this.versionablePermission.canReadAll();
    }

    @Override
    public boolean canReadProperties() {
        return this.versionablePermission.canReadProperties();
    }

    @Override
    public boolean isGranted(long permissions) {
        return this.versionablePermission.isGranted(permissions);
    }

    @Override
    public boolean isGranted(long permissions, @NotNull PropertyState property) {
        return this.versionablePermission.isGranted(permissions, property);
    }
}

