/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.jcr.NoSuchWorkspaceException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.InitialContent;
import org.apache.jackrabbit.oak.OakInitializer;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.jmx.QueryEngineSettingsMBean;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.core.ContentRepositoryImpl;
import org.apache.jackrabbit.oak.management.RepositoryManager;
import org.apache.jackrabbit.oak.plugins.atomic.AtomicCounterEditorProvider;
import org.apache.jackrabbit.oak.plugins.commit.ConflictHook;
import org.apache.jackrabbit.oak.plugins.commit.ConflictValidatorProvider;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.CompositeIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexMBeanRegistration;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateProvider;
import org.apache.jackrabbit.oak.plugins.index.counter.NodeCounterEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounter;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounterMBean;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounterOld;
import org.apache.jackrabbit.oak.plugins.index.nodetype.NodeTypeIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedPropertyIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindex;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindexMBean;
import org.apache.jackrabbit.oak.plugins.index.reference.ReferenceEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.reference.ReferenceIndexProvider;
import org.apache.jackrabbit.oak.plugins.itemsave.ItemSaveValidatorProvider;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.name.NameValidatorProvider;
import org.apache.jackrabbit.oak.plugins.name.NamespaceEditorProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.TypeEditorProvider;
import org.apache.jackrabbit.oak.plugins.observation.ChangeCollectorProvider;
import org.apache.jackrabbit.oak.plugins.version.VersionHook;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.stats.QueryStatsMBean;
import org.apache.jackrabbit.oak.security.internal.SecurityProviderBuilder;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandlers;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.commit.ResetCommitAttributeHook;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.descriptors.AggregatingDescriptors;
import org.apache.jackrabbit.oak.spi.lifecycle.CompositeInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.query.CompositeQueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProviderAware;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.DefaultWhiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAware;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oak {
    private static final Logger LOG = LoggerFactory.getLogger(Oak.class);
    public static final String DEFAULT_WORKSPACE_NAME = "default";
    private final NodeStore store;
    private final List<RepositoryInitializer> initializers = Lists.newArrayList();
    private AnnotatedQueryEngineSettings queryEngineSettings = new AnnotatedQueryEngineSettings();
    private final List<QueryIndexProvider> queryIndexProviders = Lists.newArrayList();
    private final List<IndexEditorProvider> indexEditorProviders = Lists.newArrayList();
    private final List<CommitHook> commitHooks = Lists.newArrayList();
    private final List<Observer> observers = Lists.newArrayList();
    private List<EditorProvider> editorProviders = Lists.newArrayList();
    private CompositeConflictHandler conflictHandler;
    private SecurityProvider securityProvider;
    private ScheduledExecutorService scheduledExecutor;
    private Executor executor;
    private final Closer closer = Closer.create();
    private ContentRepository contentRepository;
    private Clusterable clusterable;
    private MBeanServer mbeanServer;
    private String defaultWorkspaceName = "default";
    private Whiteboard whiteboard = new DefaultWhiteboard(){

        @Override
        public <T> Registration register(final Class<T> type, T service, Map<?, ?> properties) {
            final Registration registration = super.register(type, service, properties);
            final Closer observerSubscription = Closer.create();
            ScheduledFuture<?> future = null;
            if (type == Runnable.class) {
                Runnable runnable = (Runnable)service;
                Long period = (Long)Oak.getValue(properties, "scheduler.period", Long.class);
                if (period != null) {
                    Boolean concurrent = (Boolean)Oak.getValue(properties, "scheduler.concurrent", Boolean.class, Boolean.FALSE);
                    future = concurrent.booleanValue() ? Oak.this.getScheduledExecutor().scheduleAtFixedRate(runnable, period, period, TimeUnit.SECONDS) : Oak.this.getScheduledExecutor().scheduleWithFixedDelay(runnable, period, period, TimeUnit.SECONDS);
                }
            } else if (type == Observer.class && Oak.this.store instanceof Observable) {
                observerSubscription.register(((Observable)((Object)Oak.this.store)).addObserver((Observer)service));
            }
            ObjectName objectName = null;
            Object name = properties.get("jmx.objectname");
            if (Oak.this.mbeanServer != null && name != null) {
                try {
                    objectName = name instanceof ObjectName ? (ObjectName)name : new ObjectName(String.valueOf(name));
                    if (type.getName().equals(service.getClass().getName().concat("MBean")) || service instanceof StandardMBean) {
                        Oak.this.mbeanServer.registerMBean(service, objectName);
                    } else {
                        Oak.this.mbeanServer.registerMBean(new StandardMBean(service, type), objectName);
                    }
                }
                catch (JMException e) {
                    LOG.warn("Unexpected exception while registering MBean of type [{}] against name [{}]", new Object[]{type, objectName, e});
                }
            }
            final ScheduledFuture<?> f = future;
            final ObjectName on = objectName;
            return new Registration(){

                @Override
                public void unregister() {
                    if (f != null) {
                        f.cancel(false);
                    }
                    if (on != null) {
                        try {
                            Oak.this.mbeanServer.unregisterMBean(on);
                        }
                        catch (JMException e) {
                            LOG.warn("Unexpected exception while unregistering MBean of type {} against name {} ", new Object[]{type, on, e});
                        }
                    }
                    try {
                        observerSubscription.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Unexpected IOException while unsubscribing observer", (Throwable)e);
                    }
                    registration.unregister();
                }
            };
        }
    };
    private Map<String, Long> asyncTasks;
    private boolean failOnMissingIndexProvider;

    public static ScheduledExecutorService defaultScheduledExecutor() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(32, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r, this.createName());
                thread.setDaemon(true);
                return thread;
            }

            private String createName() {
                return "oak-scheduled-executor-" + this.counter.getAndIncrement();
            }
        });
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static ExecutorService defaultExecutorService() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r, this.createName());
                thread.setDaemon(true);
                thread.setPriority(1);
                return thread;
            }

            private String createName() {
                return "oak-executor-" + this.counter.getAndIncrement();
            }
        });
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private synchronized ScheduledExecutorService getScheduledExecutor() {
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = Oak.defaultScheduledExecutor();
            this.closer.register((Closeable)new ExecutorCloser(this.scheduledExecutor));
        }
        return this.scheduledExecutor;
    }

    private synchronized Executor getExecutor() {
        if (this.executor == null) {
            ExecutorService executorService = Oak.defaultExecutorService();
            this.executor = executorService;
            this.closer.register((Closeable)new ExecutorCloser(executorService));
        }
        return this.executor;
    }

    private static <T> T getValue(Map<?, ?> properties, String name, Class<T> type, T def) {
        Object value = properties.get(name);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return def;
    }

    private static <T> T getValue(Map<?, ?> properties, String name, Class<T> type) {
        return Oak.getValue(properties, name, type, null);
    }

    public Oak(NodeStore store) {
        this.store = (NodeStore)Preconditions.checkNotNull((Object)store);
    }

    public Oak() {
        this(new MemoryNodeStore());
    }

    @NotNull
    public Oak with(@NotNull Clusterable c) {
        this.clusterable = (Clusterable)Preconditions.checkNotNull((Object)c);
        return this;
    }

    @NotNull
    public Oak with(@NotNull String defaultWorkspaceName) {
        this.defaultWorkspaceName = (String)Preconditions.checkNotNull((Object)defaultWorkspaceName);
        return this;
    }

    @NotNull
    public Oak with(@NotNull RepositoryInitializer initializer) {
        this.initializers.add((RepositoryInitializer)Preconditions.checkNotNull((Object)initializer));
        return this;
    }

    @NotNull
    public Oak with(@NotNull QueryLimits settings) {
        this.queryEngineSettings.setFailTraversal(settings.getFailTraversal());
        this.queryEngineSettings.setFullTextComparisonWithoutIndex(settings.getFullTextComparisonWithoutIndex());
        this.queryEngineSettings.setLimitInMemory(settings.getLimitInMemory());
        this.queryEngineSettings.setLimitReads(settings.getLimitReads());
        this.queryEngineSettings.setStrictPathRestriction(settings.getStrictPathRestriction());
        return this;
    }

    @NotNull
    public Oak with(@NotNull QueryIndexProvider provider) {
        this.queryIndexProviders.add((QueryIndexProvider)Preconditions.checkNotNull((Object)provider));
        return this;
    }

    @NotNull
    public Oak with(@NotNull IndexEditorProvider provider) {
        this.indexEditorProviders.add((IndexEditorProvider)Preconditions.checkNotNull((Object)provider));
        return this;
    }

    @NotNull
    public Oak with(@NotNull CommitHook hook) {
        Preconditions.checkNotNull((Object)hook);
        this.withEditorHook();
        this.commitHooks.add(hook);
        return this;
    }

    private void withEditorHook() {
        if (!this.editorProviders.isEmpty()) {
            this.commitHooks.add(new EditorHook(CompositeEditorProvider.compose(this.editorProviders)));
            this.editorProviders = Lists.newArrayList();
        }
    }

    @NotNull
    public Oak with(@NotNull EditorProvider provider) {
        this.editorProviders.add((EditorProvider)Preconditions.checkNotNull((Object)provider));
        return this;
    }

    @NotNull
    public Oak with(final @NotNull Editor editor) {
        Preconditions.checkNotNull((Object)editor);
        return this.with(new EditorProvider(){

            @Override
            @NotNull
            public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) {
                return editor;
            }
        });
    }

    @NotNull
    public Oak with(@NotNull SecurityProvider securityProvider) {
        this.securityProvider = (SecurityProvider)Preconditions.checkNotNull((Object)securityProvider);
        return this;
    }

    @Deprecated
    @NotNull
    public Oak with(@NotNull ConflictHandler conflictHandler) {
        return this.with(ConflictHandlers.wrap(conflictHandler));
    }

    @NotNull
    public Oak with(@NotNull ThreeWayConflictHandler conflictHandler) {
        Preconditions.checkNotNull((Object)conflictHandler);
        this.withEditorHook();
        if (this.conflictHandler == null) {
            if (conflictHandler instanceof CompositeConflictHandler) {
                this.conflictHandler = (CompositeConflictHandler)conflictHandler;
            } else {
                this.conflictHandler = new CompositeConflictHandler();
                this.conflictHandler.addHandler(conflictHandler);
            }
            this.commitHooks.add(new ConflictHook(conflictHandler));
        } else {
            this.conflictHandler.addHandler(conflictHandler);
        }
        return this;
    }

    @NotNull
    public Oak with(@NotNull ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutor);
        return this;
    }

    @NotNull
    public Oak with(@NotNull Executor executor) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        return this;
    }

    @NotNull
    public Oak with(@NotNull MBeanServer mbeanServer) {
        this.mbeanServer = (MBeanServer)Preconditions.checkNotNull((Object)mbeanServer);
        return this;
    }

    @NotNull
    public Oak with(@NotNull Whiteboard whiteboard) {
        StatisticsProvider statisticsProvider;
        this.whiteboard = (Whiteboard)Preconditions.checkNotNull((Object)whiteboard);
        QueryEngineSettings queryEngineSettings = WhiteboardUtils.getService(whiteboard, QueryEngineSettings.class);
        if (queryEngineSettings != null) {
            this.queryEngineSettings = new AnnotatedQueryEngineSettings(queryEngineSettings);
        }
        if ((statisticsProvider = WhiteboardUtils.getService(whiteboard, StatisticsProvider.class)) != null) {
            QueryEngineSettings newSettings = new QueryEngineSettings(statisticsProvider);
            newSettings.setFullTextComparisonWithoutIndex(this.queryEngineSettings.settings.getFullTextComparisonWithoutIndex());
            newSettings.setFailTraversal(this.queryEngineSettings.getFailTraversal());
            newSettings.setFastQuerySize(this.queryEngineSettings.isFastQuerySize());
            newSettings.setLimitInMemory(this.queryEngineSettings.getLimitInMemory());
            newSettings.setLimitReads(this.queryEngineSettings.getLimitReads());
            this.queryEngineSettings = new AnnotatedQueryEngineSettings(newSettings);
        }
        return this;
    }

    @NotNull
    public Oak with(@NotNull Observer observer) {
        this.observers.add((Observer)Preconditions.checkNotNull((Object)observer));
        return this;
    }

    @Deprecated
    public Oak withAsyncIndexing() {
        return this.withAsyncIndexing("async", 5L);
    }

    public Oak withFailOnMissingIndexProvider() {
        this.failOnMissingIndexProvider = true;
        return this;
    }

    public Oak withAtomicCounter() {
        return this.with(new AtomicCounterEditorProvider(new Supplier<Clusterable>(){

            @Override
            public Clusterable get() {
                return Oak.this.clusterable;
            }
        }, new Supplier<ScheduledExecutorService>(){

            @Override
            public ScheduledExecutorService get() {
                return Oak.this.scheduledExecutor;
            }
        }, new Supplier<NodeStore>(){

            @Override
            public NodeStore get() {
                return Oak.this.store;
            }
        }, new Supplier<Whiteboard>(){

            @Override
            public Whiteboard get() {
                return Oak.this.whiteboard;
            }
        }));
    }

    public Oak withAsyncIndexing(@NotNull String name, long delayInSeconds) {
        if (this.asyncTasks == null) {
            this.asyncTasks = new HashMap<String, Long>();
        }
        Preconditions.checkState((delayInSeconds > 0L ? 1 : 0) != 0, (Object)"delayInSeconds value must be > 0");
        this.asyncTasks.put(AsyncIndexUpdate.checkValidName(name), delayInSeconds);
        return this;
    }

    @NotNull
    public Whiteboard getWhiteboard() {
        return this.whiteboard;
    }

    public ContentRepository createContentRepository() {
        if (this.contentRepository == null) {
            this.contentRepository = this.createNewContentRepository();
        }
        return this.contentRepository;
    }

    private void initialContent(IndexEditorProvider indexEditors, final QueryIndexProvider indexProvider) {
        ArrayList<CommitHook> initHooks = new ArrayList<CommitHook>(this.commitHooks);
        initHooks.add(0, ResetCommitAttributeHook.INSTANCE);
        initHooks.add(new EditorHook(new IndexUpdateProvider(indexEditors)));
        CommitHook initHook = CompositeHook.compose(initHooks);
        OakInitializer.initialize(this.store, new CompositeInitializer(this.initializers), initHook);
        Iterable workspaceInitializers = Iterables.transform(this.securityProvider.getConfigurations(), (Function)new Function<SecurityConfiguration, WorkspaceInitializer>(){

            public WorkspaceInitializer apply(SecurityConfiguration sc) {
                WorkspaceInitializer wi = sc.getWorkspaceInitializer();
                if (wi instanceof QueryIndexProviderAware) {
                    ((QueryIndexProviderAware)((Object)wi)).setQueryIndexProvider(indexProvider);
                }
                return wi;
            }
        });
        OakInitializer.initialize(workspaceInitializers, this.store, this.defaultWorkspaceName, initHook);
    }

    private ContentRepository createNewContentRepository() {
        if (this.securityProvider instanceof WhiteboardAware) {
            ((WhiteboardAware)((Object)this.securityProvider)).setWhiteboard(this.whiteboard);
        }
        for (SecurityConfiguration securityConfiguration : this.securityProvider.getConfigurations()) {
            RepositoryInitializer ri = securityConfiguration.getRepositoryInitializer();
            if (ri != RepositoryInitializer.DEFAULT) {
                this.initializers.add(ri);
            }
            for (ThreeWayConflictHandler tch : securityConfiguration.getConflictHandlers()) {
                this.with(tch);
            }
        }
        final RepoStateCheckHook repoStateCheckHook = new RepoStateCheckHook();
        final ArrayList arrayList = Lists.newArrayList();
        arrayList.add(this.whiteboard.register(Executor.class, this.getExecutor(), Collections.emptyMap()));
        IndexEditorProvider indexEditors = CompositeIndexEditorProvider.compose(this.indexEditorProviders);
        QueryIndexProvider indexProvider = CompositeQueryIndexProvider.compose(this.queryIndexProviders);
        this.withEditorHook();
        this.commitHooks.add(repoStateCheckHook);
        this.initialContent(indexEditors, indexProvider);
        if (this.asyncTasks != null) {
            IndexMBeanRegistration indexRegistration = new IndexMBeanRegistration(this.whiteboard);
            arrayList.add(indexRegistration);
            for (Map.Entry<String, Long> entry : this.asyncTasks.entrySet()) {
                AsyncIndexUpdate task = new AsyncIndexUpdate(entry.getKey(), this.store, indexEditors);
                indexRegistration.registerAsyncIndexer(task, entry.getValue());
                this.closer.register((Closeable)task);
            }
            PropertyIndexAsyncReindex asyncPI = new PropertyIndexAsyncReindex(new AsyncIndexUpdate("async-reindex", this.store, indexEditors, true), this.getExecutor());
            arrayList.add(WhiteboardUtils.registerMBean(this.whiteboard, PropertyIndexAsyncReindexMBean.class, asyncPI, "PropertyIndexAsyncReindex", "async"));
        }
        if (NodeCounter.USE_OLD_COUNTER) {
            arrayList.add(WhiteboardUtils.registerMBean(this.whiteboard, NodeCounterMBean.class, new NodeCounterOld(this.store), "NodeCounter", "nodeCounter"));
        } else {
            arrayList.add(WhiteboardUtils.registerMBean(this.whiteboard, NodeCounterMBean.class, new NodeCounter(this.store), "NodeCounter", "nodeCounter"));
        }
        arrayList.add(WhiteboardUtils.registerMBean(this.whiteboard, QueryEngineSettingsMBean.class, this.queryEngineSettings, "QueryEngineSettings", "settings"));
        arrayList.add(WhiteboardUtils.registerMBean(this.whiteboard, QueryStatsMBean.class, this.queryEngineSettings.getQueryStats(), "QueryStats", "Oak Query Statistics (Extended)"));
        this.queryEngineSettings.unwrap().getQueryValidator().init(this.store);
        this.commitHooks.add(new EditorHook(new IndexUpdateProvider(indexEditors, this.failOnMissingIndexProvider)));
        for (Observer observer : this.observers) {
            arrayList.add(this.whiteboard.register(Observer.class, observer, Collections.emptyMap()));
        }
        RepositoryManager repositoryManager = new RepositoryManager(this.whiteboard);
        arrayList.add(WhiteboardUtils.registerMBean(this.whiteboard, RepositoryManagementMBean.class, repositoryManager, "RepositoryManagement", repositoryManager.getName()));
        CommitHook composite = CompositeHook.compose(this.commitHooks);
        arrayList.add(this.whiteboard.register(CommitHook.class, composite, Collections.emptyMap()));
        Tracker<Descriptors> tracker = this.whiteboard.track(Descriptors.class);
        return new ContentRepositoryImpl(this.store, composite, this.defaultWorkspaceName, this.queryEngineSettings.unwrap(), indexProvider, this.securityProvider, new AggregatingDescriptors(tracker)){

            @Override
            public void close() throws IOException {
                super.close();
                repoStateCheckHook.close();
                new CompositeRegistration(arrayList).unregister();
                Oak.this.closer.close();
            }
        };
    }

    public ContentSession createContentSession() {
        try {
            return this.createContentRepository().login(null, null);
        }
        catch (NoSuchWorkspaceException e) {
            throw new IllegalStateException("Default workspace not found", e);
        }
        catch (LoginException e) {
            throw new IllegalStateException("Anonymous login not allowed", e);
        }
    }

    public Root createRoot() {
        return this.createContentSession().getLatestRoot();
    }

    public static class OakDefaultComponents {
        @Deprecated
        public static final OakDefaultComponents INSTANCE = new OakDefaultComponents();
        private final Iterable<CommitHook> commitHooks = ImmutableList.of((Object)new VersionHook());
        private final Iterable<RepositoryInitializer> repositoryInitializers = ImmutableList.of((Object)new InitialContent());
        private final Iterable<EditorProvider> editorProviders = ImmutableList.of((Object)new ItemSaveValidatorProvider(), (Object)new NameValidatorProvider(), (Object)new NamespaceEditorProvider(), (Object)new TypeEditorProvider(), (Object)new ConflictValidatorProvider(), (Object)new ChangeCollectorProvider());
        private final Iterable<IndexEditorProvider> indexEditorProviders = ImmutableList.of((Object)new ReferenceEditorProvider(), (Object)new PropertyIndexEditorProvider(), (Object)new NodeCounterEditorProvider(), (Object)new OrderedPropertyIndexEditorProvider());
        private final Iterable<QueryIndexProvider> queryIndexProviders = ImmutableList.of((Object)new ReferenceIndexProvider(), (Object)new PropertyIndexProvider(), (Object)new NodeTypeIndexProvider());
        private final SecurityProvider securityProvider = SecurityProviderBuilder.newBuilder().build();

        public Iterable<CommitHook> commitHooks() {
            return this.commitHooks;
        }

        public Iterable<RepositoryInitializer> repositoryInitializers() {
            return this.repositoryInitializers;
        }

        public Iterable<EditorProvider> editorProviders() {
            return this.editorProviders;
        }

        public Iterable<IndexEditorProvider> indexEditorProviders() {
            return this.indexEditorProviders;
        }

        public Iterable<QueryIndexProvider> queryIndexProviders() {
            return this.queryIndexProviders;
        }

        public SecurityProvider securityProvider() {
            return this.securityProvider;
        }
    }

    private static final class AnnotatedQueryEngineSettings
    extends AnnotatedStandardMBean
    implements QueryEngineSettingsMBean {
        private final QueryEngineSettings settings;

        private AnnotatedQueryEngineSettings(QueryEngineSettings settings) {
            super(QueryEngineSettingsMBean.class);
            this.settings = settings;
        }

        private AnnotatedQueryEngineSettings() {
            this(new QueryEngineSettings());
        }

        @Override
        public long getLimitInMemory() {
            return this.settings.getLimitInMemory();
        }

        @Override
        public void setLimitInMemory(long limitInMemory) {
            this.settings.setLimitInMemory(limitInMemory);
        }

        @Override
        public long getLimitReads() {
            return this.settings.getLimitReads();
        }

        @Override
        public void setLimitReads(long limitReads) {
            this.settings.setLimitReads(limitReads);
        }

        @Override
        public boolean getFailTraversal() {
            return this.settings.getFailTraversal();
        }

        @Override
        public void setFailTraversal(boolean failQueriesWithoutIndex) {
            this.settings.setFailTraversal(failQueriesWithoutIndex);
        }

        @Override
        public boolean isFastQuerySize() {
            return this.settings.isFastQuerySize();
        }

        @Override
        public void setFastQuerySize(boolean fastQuerySize) {
            this.settings.setFastQuerySize(fastQuerySize);
        }

        @Override
        public String getStrictPathRestriction() {
            return this.settings.getStrictPathRestriction();
        }

        @Override
        public void setStrictPathRestriction(String strictPathRestriction) {
            this.settings.setStrictPathRestriction(strictPathRestriction);
        }

        @Override
        public void setQueryValidatorPattern(String key, String pattern, String comment, boolean failQuery) {
            this.settings.getQueryValidator().setPattern(key, pattern, comment, failQuery);
        }

        @Override
        public String getQueryValidatorJson() {
            return this.settings.getQueryValidator().getJson();
        }

        public QueryStatsMBean getQueryStats() {
            return this.settings.getQueryStats();
        }

        public QueryEngineSettings unwrap() {
            return this.settings;
        }

        public String toString() {
            return this.settings.toString();
        }

        void setFullTextComparisonWithoutIndex(boolean fullTextComparisonWithoutIndex) {
            this.settings.setFullTextComparisonWithoutIndex(fullTextComparisonWithoutIndex);
        }
    }

    private static class RepoStateCheckHook
    implements CommitHook,
    Closeable {
        private volatile boolean closed;

        private RepoStateCheckHook() {
        }

        @Override
        @NotNull
        public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
            if (this.closed) {
                throw new CommitFailedException("Oak", 2, "ContentRepository closed");
            }
            return after;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }
    }
}

