/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.jmx;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.apache.jackrabbit.oak.commons.TimeDurationFormatter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementOperation<R>
extends FutureTask<R> {
    private static final Logger LOG = LoggerFactory.getLogger(ManagementOperation.class);
    private static final AtomicInteger idGen = new AtomicInteger();
    protected final int id = idGen.incrementAndGet();
    @NotNull
    protected final String name;
    @NotNull
    private final Supplier<String> statusMessage;

    public static <R> ManagementOperation<R> newManagementOperation(@NotNull String name, @NotNull Callable<R> task) {
        return new ManagementOperation<R>(name, (Supplier<String>)Suppliers.ofInstance((Object)""), task);
    }

    public static <R> ManagementOperation<R> newManagementOperation(@NotNull String name, @NotNull Supplier<String> statusMessage, @NotNull Callable<R> task) {
        return new ManagementOperation<R>(name, statusMessage, task);
    }

    @NotNull
    public static <R> ManagementOperation<R> done(String name, final R result) {
        return new ManagementOperation<R>("done", Suppliers.ofInstance((Object)""), new Callable<R>(){

            @Override
            public R call() throws Exception {
                return result;
            }
        }){

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public R get() {
                return result;
            }

            @Override
            public void run() {
                throw new IllegalStateException("This task is done");
            }

            @Override
            public Status getStatus() {
                return Status.none(this, "NA");
            }
        };
    }

    private ManagementOperation(@NotNull String name, @NotNull Supplier<String> statusMessage, @NotNull Callable<R> task) {
        super(task);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.statusMessage = (Supplier)Preconditions.checkNotNull(statusMessage);
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Status getStatus() {
        if (this.isCancelled()) {
            return Status.failed(this, this.name + " cancelled");
        }
        if (this.isDone()) {
            try {
                Object result = this.get();
                return Status.succeeded(this, this.name + " succeeded" + (result != null ? ": " + result : ""));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return Status.failed(this, this.name + " interrupted: " + e.getMessage());
            }
            catch (ExecutionException e) {
                LOG.error("{} failed", (Object)this.name, (Object)e.getCause());
                return Status.failed(this, this.name + " failed: " + e.getCause().getMessage());
            }
        }
        return Status.running(this, this.name + " running: " + (String)this.statusMessage.get());
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("id", this.id).toString();
    }

    public static final class Status {
        public static final String ITEM_CODE = "code";
        public static final String ITEM_ID = "id";
        public static final String ITEM_MESSAGE = "message";
        public static final String[] ITEM_NAMES = new String[]{"code", "id", "message"};
        public static final CompositeType ITEM_TYPES = Status.createItemTypes();
        private final RepositoryManagementMBean.StatusCode code;
        private final int id;
        private final String message;

        private static CompositeType createItemTypes() {
            try {
                return new CompositeType("status", "status", ITEM_NAMES, ITEM_NAMES, new OpenType[]{SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.STRING});
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        private Status(RepositoryManagementMBean.StatusCode code, int id, String message) {
            this.code = code;
            this.id = id;
            this.message = message == null ? "" : message;
        }

        public static Status unavailable(String message) {
            return new Status(RepositoryManagementMBean.StatusCode.UNAVAILABLE, idGen.incrementAndGet(), message);
        }

        public static Status none(String message) {
            return new Status(RepositoryManagementMBean.StatusCode.NONE, idGen.incrementAndGet(), message);
        }

        public static Status initiated(String message) {
            return new Status(RepositoryManagementMBean.StatusCode.INITIATED, idGen.incrementAndGet(), message);
        }

        public static Status running(String message) {
            return new Status(RepositoryManagementMBean.StatusCode.RUNNING, idGen.incrementAndGet(), message);
        }

        public static Status succeeded(String message) {
            return new Status(RepositoryManagementMBean.StatusCode.SUCCEEDED, idGen.incrementAndGet(), message);
        }

        public static Status failed(String message) {
            return new Status(RepositoryManagementMBean.StatusCode.FAILED, idGen.incrementAndGet(), message);
        }

        public static Status unavailable(ManagementOperation<?> op, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.UNAVAILABLE, op.getId(), message);
        }

        public static Status none(ManagementOperation<?> op, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.NONE, op.getId(), message);
        }

        public static Status initiated(ManagementOperation<?> op, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.INITIATED, op.getId(), message);
        }

        public static Status running(ManagementOperation<?> op, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.RUNNING, op.getId(), message);
        }

        public static Status succeeded(ManagementOperation<?> op, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.SUCCEEDED, op.getId(), message);
        }

        public static Status failed(ManagementOperation<?> op, String message) {
            return new Status(RepositoryManagementMBean.StatusCode.FAILED, op.getId(), message);
        }

        public static String formatTime(long nanos) {
            return TimeDurationFormatter.forLogging().format(nanos, TimeUnit.NANOSECONDS);
        }

        public static Status fromCompositeData(CompositeData status) {
            int code = Status.toInt(status.get(ITEM_CODE));
            int id = Status.toInt(status.get(ITEM_ID));
            String message = Status.toString(status.get(ITEM_MESSAGE));
            return new Status(RepositoryManagementMBean.StatusCode.values()[code], id, message);
        }

        private static int toInt(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            throw new IllegalArgumentException("Not an integer value:" + value);
        }

        private static String toString(Object value) {
            if (value instanceof String) {
                return (String)value;
            }
            throw new IllegalArgumentException("Not a string value:" + value);
        }

        public CompositeData toCompositeData() {
            try {
                Object[] values = new Object[]{this.code.ordinal(), this.id, this.message};
                return new CompositeDataSupport(ITEM_TYPES, ITEM_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public static TabularData toTabularData(Iterable<Status> statuses) {
            try {
                TabularDataSupport tab = new TabularDataSupport(new TabularType("Statuses", "List of statuses", ITEM_TYPES, new String[]{ITEM_ID}));
                for (Status status : statuses) {
                    tab.put(status.toCompositeData());
                }
                return tab;
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public RepositoryManagementMBean.StatusCode getCode() {
            return this.code;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.code.name;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSuccess() {
            return RepositoryManagementMBean.StatusCode.SUCCEEDED == this.code;
        }

        public boolean isFailure() {
            return RepositoryManagementMBean.StatusCode.FAILED == this.code;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).addValue((Object)this.code).add(ITEM_ID, this.id).add(ITEM_MESSAGE, (Object)this.message).toString();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            Status status = (Status)that;
            return this.id == status.id && this.code == status.code && this.message.equals(status.message);
        }

        public int hashCode() {
            int result = this.code.hashCode();
            result = 31 * result + this.id;
            result = 31 * result + this.message.hashCode();
            return result;
        }
    }
}

