/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import java.security.Principal;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalQueryManager;
import org.jetbrains.annotations.NotNull;

public class PrincipalManagerDelegator
implements PrincipalManager,
PrincipalQueryManager {
    private final SessionDelegate delegate;
    private final PrincipalManager principalManager;

    public PrincipalManagerDelegator(SessionDelegate delegate, PrincipalManager principalManager) {
        this.principalManager = principalManager;
        this.delegate = delegate;
    }

    public boolean hasPrincipal(final String principalName) {
        return this.delegate.safePerform(new SessionOperation<Boolean>("hasPrincipal"){

            @Override
            @NotNull
            public Boolean perform() {
                return PrincipalManagerDelegator.this.principalManager.hasPrincipal(principalName);
            }
        });
    }

    public Principal getPrincipal(final String principalName) {
        try {
            return this.delegate.performNullable(new SessionOperation<Principal>("getPrincipal"){

                @Override
                public Principal performNullable() {
                    return PrincipalManagerDelegator.this.principalManager.getPrincipal(principalName);
                }
            });
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unexpected exception thrown by operation 'getPrincipal'", e);
        }
    }

    public PrincipalIterator findPrincipals(final String simpleFilter) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("findPrincipals"){

            @Override
            @NotNull
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.findPrincipals(simpleFilter);
            }
        });
    }

    public PrincipalIterator findPrincipals(final String simpleFilter, final int searchType) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("findPrincipals"){

            @Override
            @NotNull
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.findPrincipals(simpleFilter, searchType);
            }
        });
    }

    public PrincipalIterator getPrincipals(final int searchType) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("getPrincipals"){

            @Override
            @NotNull
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.getPrincipals(searchType);
            }
        });
    }

    public PrincipalIterator getGroupMembership(final Principal principal) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("getGroupMembership"){

            @Override
            @NotNull
            public PrincipalIterator perform() {
                return PrincipalManagerDelegator.this.principalManager.getGroupMembership(principal);
            }
        });
    }

    public Principal getEveryone() {
        return this.delegate.safePerform(new SessionOperation<Principal>("getEveryone"){

            @Override
            @NotNull
            public Principal perform() {
                return PrincipalManagerDelegator.this.principalManager.getEveryone();
            }
        });
    }

    @Override
    public PrincipalIterator findPrincipals(final String simpleFilter, final boolean fullText, final int searchType, final long offset, final long limit) {
        return this.delegate.safePerform(new SessionOperation<PrincipalIterator>("findPrincipals"){

            @Override
            @NotNull
            public PrincipalIterator perform() {
                if (PrincipalManagerDelegator.this.principalManager instanceof PrincipalQueryManager) {
                    return ((PrincipalQueryManager)PrincipalManagerDelegator.this.principalManager).findPrincipals(simpleFilter, fullText, searchType, offset, limit);
                }
                PrincipalIterator pi = PrincipalManagerDelegator.this.principalManager.findPrincipals(simpleFilter, searchType);
                pi.skip(offset);
                return pi;
            }
        });
    }
}

