/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.jcr.delegate.AuthorizableDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.ImpersonationDelegator;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;

final class UserDelegator
extends AuthorizableDelegator
implements User {
    private UserDelegator(SessionDelegate sessionDelegate, User userDelegate) {
        super(sessionDelegate, (Authorizable)userDelegate);
    }

    static User wrap(SessionDelegate sessionDelegate, User user) {
        if (user == null) {
            return null;
        }
        return new UserDelegator(sessionDelegate, user);
    }

    @NotNull
    static User unwrap(@NotNull User user) {
        if (user instanceof UserDelegator) {
            return ((UserDelegator)user).getDelegate();
        }
        return user;
    }

    private User getDelegate() {
        return (User)this.delegate;
    }

    public boolean isAdmin() {
        return this.sessionDelegate.safePerform(new SessionOperation<Boolean>("isAdmin"){

            @Override
            @NotNull
            public Boolean perform() {
                return UserDelegator.this.getDelegate().isAdmin();
            }
        });
    }

    public boolean isSystemUser() {
        return this.sessionDelegate.safePerform(new SessionOperation<Boolean>("isSystemUser"){

            @Override
            @NotNull
            public Boolean perform() {
                return UserDelegator.this.getDelegate().isSystemUser();
            }
        });
    }

    public Credentials getCredentials() {
        return this.sessionDelegate.safePerform(new SessionOperation<Credentials>("getCredentials"){

            @Override
            @NotNull
            public Credentials perform() throws RepositoryException {
                return UserDelegator.this.getDelegate().getCredentials();
            }
        });
    }

    public Impersonation getImpersonation() {
        return this.sessionDelegate.safePerform(new SessionOperation<Impersonation>("getImpersonation"){

            @Override
            @NotNull
            public Impersonation perform() throws RepositoryException {
                Impersonation impersonation = UserDelegator.this.getDelegate().getImpersonation();
                return ImpersonationDelegator.wrap(UserDelegator.this.sessionDelegate, impersonation);
            }
        });
    }

    public void changePassword(final String password) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("changePassword", true){

            @Override
            public void performVoid() throws RepositoryException {
                UserDelegator.this.getDelegate().changePassword(password);
            }
        });
    }

    public void changePassword(final String password, final String oldPassword) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("changePassword", true){

            @Override
            public void performVoid() throws RepositoryException {
                UserDelegator.this.getDelegate().changePassword(password, oldPassword);
            }
        });
    }

    public void disable(final String reason) throws RepositoryException {
        this.sessionDelegate.performVoid(new SessionOperation<Void>("disable", true){

            @Override
            public void performVoid() throws RepositoryException {
                UserDelegator.this.getDelegate().disable(reason);
            }
        });
    }

    public boolean isDisabled() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("isDisabled"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return UserDelegator.this.getDelegate().isDisabled();
            }
        });
    }

    public String getDisabledReason() throws RepositoryException {
        return this.sessionDelegate.performNullable(new SessionOperation<String>("getDisabledReason"){

            @Override
            public String performNullable() throws RepositoryException {
                return UserDelegator.this.getDelegate().getDisabledReason();
            }
        });
    }
}

