/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.counter;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.counter.ApproximateCounter;
import org.apache.jackrabbit.oak.plugins.index.counter.SipHash;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounter;
import org.apache.jackrabbit.oak.plugins.index.property.Multiplexers;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.Nullable;

public class NodeCounterEditor
implements Editor {
    public static final String DATA_NODE_NAME = ":index";
    public static final String COUNT_PROPERTY_NAME = ":count";
    public static final String COUNT_HASH_PROPERTY_NAME = ":cnt";
    public static final int DEFAULT_RESOLUTION = 1000;
    private final NodeCounterRoot root;
    private final NodeCounterEditor parent;
    private final String name;
    private final MountInfoProvider mountInfoProvider;
    private final Map<Mount, Integer> countOffsets;
    private final Mount currentMount;
    private final boolean mountCanChange;
    private SipHash hash;

    NodeCounterEditor(NodeCounterRoot root, MountInfoProvider mountInfoProvider) {
        this.root = root;
        this.name = "/";
        this.parent = null;
        this.mountInfoProvider = mountInfoProvider;
        this.currentMount = mountInfoProvider.getDefaultMount();
        this.mountCanChange = true;
        this.countOffsets = new HashMap<Mount, Integer>();
    }

    private NodeCounterEditor(NodeCounterRoot root, NodeCounterEditor parent, String name, SipHash hash, MountInfoProvider mountInfoProvider) {
        this.parent = parent;
        this.root = root;
        this.name = name;
        this.hash = hash;
        this.mountInfoProvider = mountInfoProvider;
        this.countOffsets = new HashMap<Mount, Integer>();
        if (parent.mountCanChange) {
            String path = this.getPath();
            this.currentMount = mountInfoProvider.getMountByPath(path);
            this.mountCanChange = this.currentMount.isDefault() && this.supportMounts(path);
        } else {
            this.currentMount = this.parent.currentMount;
            this.mountCanChange = false;
        }
    }

    private SipHash getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        SipHash h = this.parent == null ? new SipHash(this.root.seed) : new SipHash(this.parent.getHash(), this.name.hashCode());
        this.hash = h;
        return h;
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (NodeCounter.COUNT_HASH) {
            this.leaveNew(before, after);
            return;
        }
        this.leaveOld(before, after);
    }

    private void leaveOld(NodeState before, NodeState after) throws CommitFailedException {
        if (this.countOffsets.isEmpty()) {
            return;
        }
        boolean updated = false;
        for (Map.Entry<Mount, Integer> e : this.countOffsets.entrySet()) {
            NodeBuilder builder;
            PropertyState p;
            long count;
            long offset = ApproximateCounter.calculateOffset(e.getValue().intValue(), this.root.resolution);
            if (offset == 0L || (offset = ApproximateCounter.adjustOffset(count = (p = (builder = this.getBuilder(e.getKey())).getProperty(COUNT_PROPERTY_NAME)) == null ? 0L : p.getValue(Type.LONG), offset, this.root.resolution)) == 0L) continue;
            updated = true;
            if ((count += offset) == 0L) {
                if (builder.getChildNodeCount(1L) >= 0L) {
                    builder.removeProperty(COUNT_PROPERTY_NAME);
                    continue;
                }
                builder.remove();
                continue;
            }
            builder.setProperty(COUNT_PROPERTY_NAME, count);
        }
        if (updated) {
            this.root.callback.indexUpdate();
        }
    }

    public void leaveNew(NodeState before, NodeState after) throws CommitFailedException {
        if (this.countOffsets.isEmpty()) {
            return;
        }
        this.root.callback.indexUpdate();
        for (Map.Entry<Mount, Integer> e : this.countOffsets.entrySet()) {
            long count;
            NodeBuilder builder = this.getBuilder(e.getKey());
            int countOffset = e.getValue();
            PropertyState p = builder.getProperty(COUNT_HASH_PROPERTY_NAME);
            long l = count = p == null ? 0L : p.getValue(Type.LONG);
            if ((count += (long)countOffset) <= 0L) {
                if (builder.getChildNodeCount(1L) >= 0L) {
                    builder.removeProperty(COUNT_HASH_PROPERTY_NAME);
                    continue;
                }
                builder.remove();
                continue;
            }
            builder.setProperty(COUNT_HASH_PROPERTY_NAME, count);
        }
    }

    private NodeBuilder getBuilder(Mount mount) {
        if (this.parent == null) {
            return this.root.definition.child(Multiplexers.getNodeForMount(mount, DATA_NODE_NAME));
        }
        return this.parent.getBuilder(mount).child(this.name);
    }

    private String getPath() {
        if (this.parent == null) {
            return this.name;
        }
        return PathUtils.concat(this.parent.getPath(), this.name);
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
    }

    @Override
    @Nullable
    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return this.getChildIndexEditor(name, null);
    }

    @Override
    @Nullable
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        if (NodeCounter.COUNT_HASH) {
            SipHash h = new SipHash(this.getHash(), name.hashCode());
            if ((h.hashCode() & this.root.bitMask) == 0) {
                this.count(this.root.bitMask + 1, this.currentMount);
            }
            return this.getChildIndexEditor(name, h);
        }
        this.count(1, this.currentMount);
        return this.getChildIndexEditor(name, null);
    }

    @Override
    @Nullable
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        if (NodeCounter.COUNT_HASH) {
            SipHash h = new SipHash(this.getHash(), name.hashCode());
            if ((h.hashCode() & this.root.bitMask) == 0) {
                this.count(-(this.root.bitMask + 1), this.currentMount);
            }
            return this.getChildIndexEditor(name, h);
        }
        this.count(-1, this.currentMount);
        return this.getChildIndexEditor(name, null);
    }

    private void count(int offset, Mount mount) {
        this.countOffsets.compute(mount, (m, v) -> v == null ? offset : v + offset);
        if (this.parent != null) {
            this.parent.count(offset, mount);
        }
    }

    private Editor getChildIndexEditor(String name, SipHash hash) {
        return new NodeCounterEditor(this.root, this, name, hash, this.mountInfoProvider);
    }

    private boolean supportMounts(String path) {
        return this.mountInfoProvider.getNonDefaultMounts().stream().anyMatch(m -> m.isSupportFragmentUnder(path) || m.isUnder(path));
    }

    public static class NodeCounterRoot {
        final int resolution;
        final long seed;
        final int bitMask;
        final NodeBuilder definition;
        final NodeState root;
        final IndexUpdateCallback callback;

        NodeCounterRoot(int resolution, long seed, NodeBuilder definition, NodeState root, IndexUpdateCallback callback) {
            this.resolution = resolution;
            this.seed = seed;
            this.bitMask = Integer.highestOneBit(resolution) * 2 - 1;
            this.definition = definition;
            this.root = root;
            this.callback = callback;
        }
    }
}

