/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.api.Blob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlob
implements Blob {
    private HashCode hashCode;

    private static ByteSource supplier(final Blob blob) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return blob.getNewStream();
            }
        };
    }

    public static boolean equal(Blob a, Blob b) {
        long al = a.length();
        long bl = b.length();
        if (al != -1L && bl != -1L && al != bl) {
            return false;
        }
        String ai = a.getContentIdentity();
        String bi = b.getContentIdentity();
        if (ai != null && bi != null && ai.equals(bi)) {
            return true;
        }
        try {
            return AbstractBlob.supplier(a).contentEquals(AbstractBlob.supplier(b));
        }
        catch (IOException e) {
            throw new IllegalStateException("Blob equality check failed", e);
        }
    }

    public static HashCode calculateSha256(final Blob blob) {
        AbstractBlob ab = blob instanceof AbstractBlob ? (AbstractBlob)blob : new AbstractBlob(){

            @Override
            public long length() {
                return blob.length();
            }

            @Override
            @NotNull
            public InputStream getNewStream() {
                return blob.getNewStream();
            }
        };
        return ab.getSha256();
    }

    protected AbstractBlob(HashCode hashCode) {
        this.hashCode = hashCode;
    }

    protected AbstractBlob() {
        this(null);
    }

    private synchronized HashCode getSha256() {
        if (this.hashCode == null) {
            try {
                this.hashCode = AbstractBlob.supplier(this).hash(Hashing.sha256());
            }
            catch (IOException e) {
                throw new IllegalStateException("Hash calculation failed", e);
            }
        }
        return this.hashCode;
    }

    protected byte[] sha256() {
        return this.getSha256().asBytes();
    }

    @Override
    @Nullable
    public String getReference() {
        return null;
    }

    @Override
    public String getContentIdentity() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AbstractBlob) {
            AbstractBlob that = (AbstractBlob)other;
            AbstractBlob abstractBlob = this;
            synchronized (abstractBlob) {
                if (this.hashCode != null) {
                    AbstractBlob abstractBlob2 = that;
                    synchronized (abstractBlob2) {
                        if (that.hashCode != null) {
                            return this.hashCode.equals((Object)that.hashCode);
                        }
                    }
                }
            }
        }
        return other instanceof Blob && AbstractBlob.equal(this, (Blob)other);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return this.getSha256().toString();
    }
}

