/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.impl.GlobalNameMapper;
import org.apache.jackrabbit.oak.namepath.impl.NamePathMapperImpl;
import org.apache.jackrabbit.oak.plugins.name.ReadWriteNamespaceRegistry;
import org.apache.jackrabbit.oak.plugins.nodetype.write.ReadWriteNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.value.jcr.ValueFactoryImpl;
import org.jetbrains.annotations.NotNull;

public final class NodeTypeRegistry {
    private final NodeTypeManager ntMgr;
    private final NamespaceRegistry nsReg;
    private final ValueFactory vf;

    private NodeTypeRegistry(final Root root) {
        this.ntMgr = new ReadWriteNodeTypeManager(){

            @Override
            @NotNull
            protected Tree getTypes() {
                return root.getTree("/jcr:system/jcr:nodeTypes");
            }

            @Override
            @NotNull
            protected Root getWriteRoot() {
                return root;
            }
        };
        this.nsReg = new ReadWriteNamespaceRegistry(root){

            @Override
            protected Root getWriteRoot() {
                return root;
            }
        };
        this.vf = new ValueFactoryImpl(root, new NamePathMapperImpl(new GlobalNameMapper(root)));
    }

    public static void register(Root root, InputStream input, String systemId) {
        new NodeTypeRegistry(root).registerNodeTypes(input, systemId);
    }

    private void registerNodeTypes(InputStream stream, String systemId) {
        try {
            CndImporter.registerNodeTypes(new InputStreamReader(stream, Charsets.UTF_8), systemId, this.ntMgr, this.nsReg, this.vf, false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read " + systemId, e);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Unable to parse " + systemId, e);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Unable to register " + systemId, e);
        }
    }
}

